#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
Resource strings to use with menus. Strings are localized according
to the current environment settings.

Require
  Python        2.3.4
  wxPython      2.5.2
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.2 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

import  py_netasq.wx.i18n                       as asqWxI18n

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# get translator for current language
_ = asqWxI18n.translator(fallback=True)


# Menu bar items  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

RS_MENU_EDIT                    = _(u'&Edit')
RS_MENU_FILE                    = _(u'&File')
RS_MENU_HELP                    = _(u'&Help')
RS_MENU_SETTINGS                = _(u'&Settings')
RS_MENU_TOOLS                   = _(u'&Tools')


# Menu items  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# note: Accelerators and keyboard shortcuts are set

RS_MENUITEM_ABOUT               = _(u'&About')
RS_MENUITEM_CLOSE               = _(u'&Close\tCtrl+W')
RS_MENUITEM_CLOSEALL            = _(u'Close All')
RS_MENUITEM_COPY                = _(u'&Copy\tCtrl+C')
RS_MENUITEM_CUT                 = _(u'C&ut\tCtrl+X')
RS_MENUITEM_FIND                = _(u'&Find\tCtrl+F')
RS_MENUITEM_FINDNEXT            = _(u'Find &Next\tF3')
RS_MENUITEM_HELP                = _(u'&Help\tF1')
RS_MENUITEM_NEW                 = _(u'&New\tCtrl+N')
RS_MENUITEM_OPEN                = _(u'&Open...\tCtrl+O')
RS_MENUITEM_OPENRECENT          = _(u'Open &Recent')
RS_MENUITEM_PASTE               = _(u'&Paste\tCtrl+V')
RS_MENUITEM_PRINT               = _(u'&Print...\tCtrl+P')
RS_MENUITEM_PRINTPREVIEW        = _(u'Print Pre&view')
RS_MENUITEM_PRINTSETUP          = _(u'Print Set&up...')
RS_MENUITEM_QUIT                = _(u'&Quit\tCtrl+Q')
RS_MENUITEM_REDO                = _(u'Redo\tCtrl+Shift+Z')
RS_MENUITEM_REPLACE             = _(u'&Replace\tCtrl+R')
RS_MENUITEM_REVERT              = _(u'Re&vert')
RS_MENUITEM_SAVE                = _(u'&Save\tCtrl+S')
RS_MENUITEM_SAVEAS              = _(u'Save &As...')
RS_MENUITEM_SELECTALL           = _(u'Select &All')
RS_MENUITEM_UNDO                = _(u'Undo\tCtrl+Z')


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

RS_MENUITEM_HINT_ABOUT          = _(u'About this application')
RS_MENUITEM_HINT_CLOSE          = _(u'Close document')
RS_MENUITEM_HINT_CLOSEALL       = _(u'Close all opened documents')
RS_MENUITEM_HINT_COPY           = _(u'Copy selected element to clipboard')
RS_MENUITEM_HINT_CUT            = _(u'Cut selected element to clipboard')
RS_MENUITEM_HINT_FIND           = _(u'Find element')
RS_MENUITEM_HINT_FINDNEXT       = _(u'Find next element')
RS_MENUITEM_HINT_HELP           = _(u'Display help')
RS_MENUITEM_HINT_NEW            = _(u'Open a new empty document')
RS_MENUITEM_HINT_OPEN           = _(u'Open an existing document')
RS_MENUITEM_HINT_OPENRECENT     = _(u'Reopen a recently opened document')
RS_MENUITEM_HINT_PASTE          = _(u'Paste element from clipboard')
RS_MENUITEM_HINT_PRINT          = _(u'Print document')
RS_MENUITEM_HINT_PRINTPREVIEW   = _(u'Preview document defore printing')
RS_MENUITEM_HINT_PRINTSETUP     = _(u'Edit print setup')
RS_MENUITEM_HINT_QUIT           = _(u'Close the application')
RS_MENUITEM_HINT_REDO           = _(u'Redo last operation')
RS_MENUITEM_HINT_REPLACE        = _(u'Search and Replace element')
RS_MENUITEM_HINT_REVERT         = _(u'Reset document state to the saved version')
RS_MENUITEM_HINT_SAVE           = _(u'Save document')
RS_MENUITEM_HINT_SAVEAS         = _(u'Save document as')
RS_MENUITEM_HINT_SELECTALL      = _(u'Select all elements')
RS_MENUITEM_HINT_UNDO           = _(u'Undo last operation')


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

if '__main__' == __name__ :
  print __file__
  print __doc__


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

del     _
del     asqWxI18n

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -