#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
Generic resource strings. Strings are localized according
to the current environment settings.

Require
  Python        2.3.4
  wxPython      2.5.2
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.2 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

import  py_netasq.wx.i18n                       as asqWxI18n

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# get translator for current language
_ = asqWxI18n.translator(fallback=True)

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# generic messages
# those may already been defined by wxPython ....
RS_ADD                          = _(u'&Add')
RS_ALL                          = _(u'&All')
RS_APPLY                        = _(u'&Apply')
RS_CANCEL                       = _(u'&Cancel')
RS_DELETE                       = _(u'&Delete')
RS_HELP                         = _(u'&Help')
RS_IGNORE                       = _(u'&Ignore')
RS_NEW                          = _(u'&New')
RS_NO                           = _(u'&No')
RS_OK                           = _(u'&Ok')
RS_REMOVE                       = _(u'R&emove')
RS_REVERT                       = _(u'Re&vert')
RS_VALIDATE                     = _(u'&Validate')
RS_YES                          = _(u'&Yes')


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

RS_RAW_ADD                      = _(u'Add')
RS_RAW_ALL                      = _(u'All')
RS_RAW_APPLY                    = _(u'Apply')
RS_RAW_CANCEL                   = _(u'Cancel')
RS_RAW_HELP                     = _(u'Help')
RS_RAW_NO                       = _(u'No')
RS_RAW_OK                       = _(u'Ok')
RS_RAW_REVERT                   = _(u'Revert')
RS_RAW_YES                      = _(u'Yes')


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

if '__main__' == __name__ :
  print __file__
  print __doc__

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

del     _
del     asqWxI18n

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -