#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
Resource strings to use with dialogs. Strings are localized according
to the current environment settings.

Require
  Python        2.3.4
  wxPython      2.5.2
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.2 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

import  py_netasq.wx.i18n                       as asqWxI18n

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# get translator for current language
_ = asqWxI18n.translator(fallback=True)


# File dialog captions  - - - - - - - - - - - - - - - - - - - - - - - - - - - -

RS_FILE_CHOOSE                  = _(u'Choose a file')
RS_FILE_OPEN                    = _(u'Open file')
RS_FILE_SAVE                    = _(u'Save file')


# File dialog wildcards - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# only the descriptive part should be translated
RS_WILDCARD_ALL                 = '|'.join( [_(u'All files (*.*)'), u'*.*'] )
RS_WILDCARD_BMP                 = '|'.join( [_(u'Bitmap files (*.bmp)'), u'*.bmp'] )
RS_WILDCARD_GIF                 = '|'.join( [_(u'GIF files (*.gif)'), u'*.gif'] )
RS_WILDCARD_PNG                 = '|'.join( [_(u'PNG files (*.png)'), u'*.png'] )
RS_WILDCARD_JPG                 = '|'.join( [_(u'JPG files (*.jpg, *.jpeg)'), u'*.jpg; *.jpeg'] )


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

if '__main__' == __name__ :
  print __file__
  print __doc__

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

del     _
del     asqWxI18n

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -