#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
Set needed 'domain' and 'locale' for localisation.

Require
  Python        2.3.4
  wxPython      2.5.2

Constants
  string        DOMAIN
  string        LOCALE

Functions
  void          reloadResources(void)
  string        getCanonicalName(int langId)
  func          translator(string domain, string locale, bool fallback)
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.4 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# __all__ should contain the entire public API. It is intended to avoid
# accidentally exporting items that are not part of the API (such as
# library modules which were imported and used within the module).

__all__ = [
      'dialogs',
      'generic',
      'menus'
    ]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

import  gettext
import  os
import  sys
import  wx

import  py_netasq.commonlib.asqPath                     as asqPath


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

DOMAIN = 'asqWx'
LOCALE = os.path.join(asqPath.directory(__file__), r'locale')

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

def reloadResources() :
    """\
      void reloadResources(void)
      
      Reload previously loaded asqWxI18n resources modules. This must be
      done to ensure that resources strings are consistent with the language
      setting found in environment variables.
    """
    def _isModule(name) :
        return sys.modules.get(name, None) is not None
    
    if '__main__' == __name__ :
      raise Exception, 'cannot guess module name'
    
    buffer = [ '.'.join((__name__, x)) for x in __all__ ]
    for key in filter(_isModule, buffer) :
      reload( sys.modules[key] )


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

def getCanonicalName(langId=wx.LANGUAGE_DEFAULT) :
    """\
      string getCanonicalName(int langId)
      
      Returns the canonical form of given 'langId'; 'langId' should be a
      wx.Language constants (such as wx.LANGUAGE_ENGLISH). If the language
      is not recognised, then the empty string is returned.
      Canonical form is the one that is used on UNIX systems: it is a
      two- or five-letter string in xx or xx_YY format, where xx is ISO 639
      code of language and YY is ISO 3166 code of the country.
      
        wx.LANGUAGE_ENGLISH     => 'en_GB'
        wx.LANGUAGE_FRENCH      => 'fr_FR'
        wx.LANGUAGE_ESPERANTO   => 'eo'
      
      Note : wx.LANGUAGE_DEFAULT is of course the user default language.
      
      param langId                wx.Language constants.
                                  defaults to wx.LANGUAGE_DEFAULT
      return                      Canonical form
    """
    buffer = wx.Locale.GetLanguageInfo(langId)
    if buffer is not None :
      return buffer.CanonicalName
    else :
      return ''


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

def translator(domain=DOMAIN, locale=LOCALE, fallback=False) :
    """\
      func translator(string domain, string locale, bool fallback)
      
      Returns the unicode enabled translating function for the asqWx module.
      If 'fallback' is set to True, then "NullTranslations.ugettext" may be
      returned if no translation file is found for the current environment
      settings.
      Note : if 'fallback' is set to False, an IOError exception may
        be raised if no translation file is found, OR if the current
        environment settings does not define a language.
      
      param domain                module domain, defaults to DOMAIN
      param locale                module locale directory.
                                  defaults to LOCALE
      param fallback              provides a default translator if none
                                  is found. defaults to False.
      return                      unicode enabled translator
    """
    return gettext.translation(domain, locale, fallback=fallback).ugettext


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

if '__main__' == __name__ :
  print __file__
  print __doc__


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# Do NOT remove those from the module's namespace !
# del     wx
# del     gettext

del     asqPath
del     os

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -