#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
A basic frame, based on wx.Frame, intended to be easier to use than
the original.

Require
  Python        2.3.4
  wxPython      2.5.2

Classes
  class         customFrame(
                  int           id,
                  string        title,
                  string        name,
                  *largs, **kargs) extends wx.Frame, asqWindow
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.8 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

import  wx
import  py_netasq.wx                                    as asqWx
import  py_netasq.wx.core                               as asqWxCore

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

class customFrame(wx.Frame, asqWxCore.window) :
    """\
      A class based on wx.Frame, intended to be easier to use than the
      original. Do not forget to check wxPython doc for a list of all
      wx.Frame methods.
      
      
      constructor customFrame(
                      int           id,
                      string        title,
                      string        name,
                      *largs, **kargs)
      
      void      OnActivate(wxActivateEvent event)
      void      OnDeActivate(wxActivateEvent event)
      
      void      OnClose(wxCloseEvent event)
      void      OnMove(wxMoveEvent event)
    """

    # Event table entries do comply to the prototype of the Bind procedure
    # > Bind(event, handler, source, id, id2)
    _eventTable = [
        { 'event' : wx.EVT_ACTIVATE     , 'handler' : '_OnActivate'     },
        { 'event' : wx.EVT_CLOSE        , 'handler' : 'OnClose'         },
        { 'event' : wx.EVT_MOVE         , 'handler' : 'OnMove'          }
      ]


  # Constructor / Destructor  - - - - - - - - - - - - - - - - - - - - - - - - -
  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def __init__( self,
                  parent = None,
                  id     = wx.ID_ANY,
                  title  = '',
                  name   = 'customFrame',
                  *largs, **kargs ) :
        """\
          constructor customFrame(
            wxWindow parent, int id, string title, string name,
            wxPoint pos, wxSize size, int style )
            
          Create a brand new window, with some built-in event handlers.
          Please take note that parameter order is slightly different from
          wx.Frame. The actual frame name will be based upon given name and
          identifier: self.name = 'name' + 'id'
          
          param parent                The window parent. This may be None.
                        If it is not None, the frame will always be displayed
                        on top of the parent window on Windows.
                        defaults to None
          param id                    The window identifier. It may take a
                        value of -1 (wx.ID_ANY) to indicate a default value.
                        defaults to wx.ID_ANY
          param title                 The caption to be displayed on the
                        frame's title bar.
                        defaults to '' (empty string)
          param name                  The name of the window. This parameter
                        is used to associate a name with the item, allowing
                        the application user to set Motif resource values for
                        individual windows.
                        defaults to 'customFrame'
          
          param pos                   The window position. A value of
                        (-1, -1) (wx.DefaultPosition) indicates a default
                        position, chosen by either the windowing system or
                        wxWidgets, depending on platform.
                        defaults to wx.DefaultPosition
          param size                  The window size. A value of (-1, -1)
                        (wx.DefaultSize) indicates a default size, chosen by
                        either the windowing system or wxWidgets, depending
                        on platform.
                        defaults to wx.DefaultSize
          param style                 The window style; check wxWidget doc.
                        (wxFrame page) for the exhaustive list.
                        defaults to wx.DEFAULT_FRAME_STYLE
        """
        asqWx.logger.trace('customFrame.__init__')
        asqWx.logger.incDepthTrace()

        # Something seems to be wrong with new style and multiple heritance.
        # Only the first super class constructor is called ?? As I want to
        # keep my remaining sanity, I will stick to ye good ol'way.
        wx.Frame.__init__( self,
                           parent = parent,
                           id     = id,
                           title  = title,
                           name   = u'%s%d' % (name, id),
                           *largs, **kargs )
        asqWxCore.window.__init__(self)
        
        self.bindEventTable(customFrame._eventTable)
        # 'closed' switch: some events can mysteriously occur
        # AFTER OnClose event
        self._closed = False
        
        asqWx.logger.decDepthTrace()


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # Special methods - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # Event handlers  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def _OnActivate(self, event) :
        """\
          void _OnActivate(wx.ActivateEvent event)
         
          Frame 'onActivate' event, because 'activate' and 'deactivate' are
          in fact the _same_ event, we need to dispatch it according to
          event.GetActive result.
         
          param  event                event to process
        """
        if self._closed :
          pass
        elif event.GetActive() :
          self.OnActivate(event)
        else :
          self.OnDeActivate(event)


    def OnActivate(self, event) :
        """\
          void OnActivate(wxActivateEvent event)
         
          Frame 'onActivate' event: frame is being activated.
         
          param  event                event to process
        """
        pass


    def OnDeActivate(self, event) :
        """\
          void OnDeActivate(wxActivateEvent event)
         
          Frame 'onActivate' event: frame frame is becoming inactivate.
         
          param  event                event to process
        """
        pass


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def OnClose(self, event) :
        """\
          void OnClose(wxCloseEvent event)
         
          Frame 'onClose' event: BEWARE, if the frame is not EXPLICTLY
          destroyed then nothing will happen, and the frame won't be
          closed.
         
          param  event                event to process
        """
        # See "Surviving with EVT_KILL_FOCUS under Microsoft Windows"
        # http://wiki.wxpython.org/index.cgi/Surviving_20with_20wxEVT_5fKILL_5fFOCUS_20under_20Microsoft_20Windows
        # A EVT_KILL_FOCUS is send AFTER frame destruction
        # please take care not to confuse wx.wxEVT_KILL_FOCUS
        # with wx.EVT_KILL_FOCUS :)
        _focusd = wx.Window.FindFocus()
        if None != _focusd :
          _focusd.Disconnect(-1, -1, wx.wxEVT_KILL_FOCUS)
        self.Destroy()
        self._closed = True


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def OnMove(self, event) :
        """\
          void OnMove(wxMoveEvent event)
          
          Frame 'onMove' event.
         
          param  event                event to process
        """
        buffer = event.GetPosition()
        asqWx.logger.debug('window.OnMove (%d, %d)' % (buffer.x, buffer.y))
        event.Skip()


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # Getters - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # Setters - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # Properties  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # /class customFrame  - - - - - - - - - - - - - - - - - - - - - - - - - - - -


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

if '__main__' == __name__ :
  print __file__
  print __doc__


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -