#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
Defines wrapper functions around wx.MessageDialog.
Based upon a WxPyWiki recipe, code stolen from "wax" and "pyCrust".

Require
  Python        2.3.4
  wxPython      2.5.2

Function
  bool          info(
                  object        parent,
                  string        message,
                  string        caption,
                  int           flags)
  bool          confirm(
                  object        parent,
                  string        message,
                  string        caption,
                  int           flags)
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.2 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

import  wx

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

def __showMsgModal(*largs, **kargs) :
    """\
      bool __showMsgModal(*largs, **kargs)
      
      Shamely ripped from the wax module; creates a MessageDialog
      instance, shows it and then frees it from memory.
      
      return                      True if user did validate dialog
    """
    dialog = wx.MessageDialog(*largs, **kargs)
    try :
      result = dialog.ShowModal() in (wx.ID_OK, wx.ID_YES)
    finally :
      dialog.Destroy()
    return result


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

def info(
        parent  = None,
        message = '',
        caption = '',
        flags   = wx.ICON_INFORMATION) :
    """\
      bool info(object parent, string message, string caption, int flags)
      
      Shows a message box with a single "ok" button and a information (i)
      icon. The dialog is modal.
      The 'style' parameter can be used to manage the dialog icon, but
      also to add buttons (the "ok" button cannot be removed). Check the
      wxWidget documentation for further infos.
      
      param parent                parent window. Dialog will be displayed
                                    over that window. Defaults to None
      param message               Message to show on the dialog.
                                    Defaults to ''
      param caption               The dialog caption.
                                    Defaults to ''
      param flags                 dialog bit flags.
                                    Defaults to wx.ICON_INFORMATION
      return                      True if user did validate dialog
    """
    return __showMsgModal(parent, message, caption, wx.OK | flags)


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

def confirm(
        parent  = None,
        message = '',
        caption = '',
        flags   = wx.ICON_QUESTION) :
    """\
      bool confirm(object parent, string message, string caption, int flags)
      
      Shows a message box with "yes" & "no" buttons and a question mark (?)
      icon. The dialog is modal.
      The 'style' parameter can be used to manage the dialog icon, but
      also to add buttons (the "yes" & "no" button cannot be removed).
      Check the wxWidget documentation for further infos.
      
      param parent                parent window. Dialog will be displayed
                                    over that window. Defaults to None
      param message               Message to show on the dialog.
                                    Defaults to ''
      param caption               The dialog caption.
                                    Defaults to ''
      param flags                 dialog bit flags.
                                    Defaults to wx.ICON_QUESTION
      return                      True if user did validate dialog
    """
    return __showMsgModal(parent, message, caption, wx.YES_NO | flags)


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

if '__main__' == __name__ :
  print __file__
  print __doc__


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -