#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
Defines wrapper functions around wx.FileDialog.

Require
  Python        2.3.4
  wxPython      2.5.2

Functions
  var           open(
                  object        parent,
                  string        caption,
                  string        defaultDir,
                  string        defaultFile,
                  string        wildcard,
                  int           flags)
  var           save(
                  object        parent,
                  string        caption,
                  string        defaultDir,
                  string        defaultFile,
                  string        wildcard,
                  int           flags)
  var           directory(
                  object        parent,
                  string        message,
                  string        defaultDir,
                  int           flags)
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.2 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

import  wx

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  
def __showFileModal(*largs, **kargs) :
    """\
      var __showFileModal(*largs, **kargs)
      
      Shamely ripped from the wax module; creates a FileDialog
      instance, shows it and then frees it from memory.
    """
    dialog = wx.FileDialog(*largs, **kargs)
    try :
      if dialog.ShowModal() not in (wx.ID_OK, wx.ID_YES) :
        result = None
      elif 0 != (dialog.GetStyle() & wx.MULTIPLE) :
        result = dialog.GetPaths()
      else :
        result = [dialog.GetPath()]
    finally :
      dialog.Destroy()
    return result


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

def __showDirModal(*largs, **kargs) :
    """\
      var __showDirModal(*largs, **kargs)
      
      Shamely ripped from the wax module; creates a DirDialog
      instance, shows it and then frees it from memory.
    """
    dialog = wx.DirDialog(*largs, **kargs)
    try :
      if wx.ID_OK != dialog.ShowModal() :
        result = None
      else :
        result = dialog.GetPath()
    finally :
      dialog.Destroy()
    return result


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

def open(
        parent       = None,
        caption      = '',
        defaultDir   = '',
        defaultFile  = '',
        wildcard     = '',
        flags        = wx.CHANGE_DIR) :
    """\
      var open(object parent, string caption, string defaultDir, string defaultFile, string wildcard, int flags)
      
      Displays the infamous "open file" dialog. The path(s) of the selected
      file(s) is(are) returned as a list, if none is selected then None is
      returned. Even if wx.MULTIPLE is not set, a list should be returned.
      Check the wxPython doc for further information about the 'flags'
      parameter (wx.FileDialog >'style').
      
      param parent                parent window. Dialog will be displayed
                                    over that window. Defaults to None
      param caption               The dialog caption.
                                    Defaults to ''
      param defaultDir            dialog directory, if none is defined then
                                    the current working directory is used.
                                    Defaults to ''
      param defaultFile           dialog preset filename. Defaults to ''
      param wildcard              dialog file filter, if none is set, then
                                    "All files (*.*)" (verbatim) is used.
                                    Defaults to ''
      param flags                 dialog bit flags.
                                    Defaults to wx.CHANGE_DIR
      return                      List of selected file paths, or None
    """
    styles = wx.OPEN | flags
    # converts any asqWxCore.Filter or asqWxCore.FilterList to a string
    wldcrd = str(wildcard)
    return __showFileModal(parent, caption, defaultDir, defaultFile, wldcrd, styles)


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

def save(
        parent       = None,
        caption      = '',
        defaultDir   = '',
        defaultFile  = '',
        wildcard     = '',
        flags        = wx.HIDE_READONLY | wx.OVERWRITE_PROMPT) :
    """\
      var save(object parent, string caption, string defaultDir, string defaultFile, string wildcard, int flags)
      
      Displays the infamous "save file" dialog. Returns the selected file's
      path, if none is selected then None is returned.
      Check the wxPython doc for further information about the 'flags'
      parameter (wx.FileDialog >'style').
      
      param parent                parent window. Dialog will be displayed
                                    over that window. Defaults to None
      param caption               dialog caption.
                                    Defaults to ''
      param defaultDir            dialog default directory, if none is
                                    defined then the current working
                                    directory is used. Defaults to ''
      param defaultFile           dialog preset filename. Defaults to ''
      param wildcard              dialog file filter, if none is set, then
                                    "All files (*.*)" (verbatim) is used.
                                    Defaults to ''
      param flags                 dialog bit flags. Defaults to
                                    wx.HIDE_READONLY | wx.OVERWRITE_PROMPT
      return                      Selected file path, or None
    """
    styles = wx.SAVE | flags
    # converts any asqWxCore.Filter or asqWxCore.FilterList to a string
    wldcrd = str(wildcard)
    result = __showFileModal(parent, caption, defaultDir, defaultFile, wldcrd, styles)
    if result is None :
      return None
    else :
      return result[0]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

def directory(
        parent      = None,
        message     = '',
        defaultDir  = '',
        flags       = 0) :
    """\
      var directory(object parent, string message, string defaultDir, int flags)
      
      Displays a directory chooser dialog, returns the selected directory
      path, or None.
      
      param parent                parent window. Dialog will be displayed
                                    over that window. Defaults to None
      param message               Message to show on the dialog.
                                    Defaults to ''
      param defaultDir            dialog directory, if none is defined then
                                    the current working directory is used.
                                    Defaults to ''
      param flags                 dialog bit flags. Defaults to 0
      return                      Selected directory path, or None
    """
    return __showDirModal(parent, message, defaultDir, flags)



# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

if '__main__' == __name__ :
  print __file__
  print __doc__


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -