#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
Defines a custom object what handles very basic control tasks.

Require
  Python        2.3.4
  wxPython      2.5.2

Classes
  class         window(void)
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.6 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

import  wx
import  py_netasq.wx                                    as asqWx

from    eventTable      import  bindEventTable, unBindEventTable

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

class window(object) :
    """\
      A basic class that binds event to handlers, using an inner event table.
      This class does also introduce OnCreate and OnDestroy handlers, that
      are triggered by constructor and destructor procedures.
      
      
      constructor window(self)
      destructor  ~window(self)
      
      void      bindEventTable(list evtTable)
      
      void      OnCreate(void)
      void      OnDestroy(void)
      
      void      OnPaint(wx.PaintEvent event)
      void      OnResize(wx.SizeEvent event)
      
      void      OnMouseMove(wx.MouseEvent event)
      void      OnMouseEnter(wx.MouseEvent event)
      void      OnMouseLeave(wx.MouseEvent event)
    """

    # Event table entries do comply to the prototype of the Bind procedure
    # > Bind(event, function, source, id, id2)
    _eventTable = [
        #~ { 'event' : wx.EVT_PAINT        , 'handler' : 'OnPaint'         },
        { 'event' : wx.EVT_SIZE         , 'handler' : 'OnResize'        },
        { 'event' : wx.EVT_MOTION       , 'handler' : 'OnMouseMove'     },
        { 'event' : wx.EVT_ENTER_WINDOW , 'handler' : 'OnMouseEnter'    },
        { 'event' : wx.EVT_LEAVE_WINDOW , 'handler' : 'OnMouseLeave'    }
      ]

  # Constructor / Destructor  - - - - - - - - - - - - - - - - - - - - - - - - -
  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def __init__(self) :
        """\
          constructor window(void)
          
          Calls 'bindEvents' and 'OnCreate' procedures.
        """
        asqWx.logger.trace('window.__init__')
        asqWx.logger.incDepthTrace()
        
        bindEventTable(self, window._eventTable)
        self.OnCreate()
        
        asqWx.logger.decDepthTrace()


    def __del__(self) :
        """\
          destructor ~window(void)
          
          Calls 'OnDestroy' procedure.
        """
        asqWx.logger.trace('window.__del__')
        asqWx.logger.incDepthTrace()
        
        self.OnDestroy()
        
        asqWx.logger.decDepthTrace()


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # Special methods - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def bindEventTable(self, evtTable) :
        """\
          void bindEventTable(list evtTable)
          
          Bind events to window, using given event table.
          
          param  evtTable             event table
        """
        bindEventTable(self, evtTable)


    def unBindEventTable(self, evtTable) :
        """\
          void unBindEventTable(list evtTable)
          
          Disconnect events found in given event table.
          This is a wxPython 2.5.2.x feature.
          
          param  evtTable             event table
        """
        unBindEventTable(self, evtTable)


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # Event handlers  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def OnCreate(self) :
        """\
          void OnCreate(void)
         
          Abstract- called by constructor, should be used to setup frame
          content (status, menu, ...).
        """
        asqWx.logger.trace('window.OnCreate')
        asqWx.logger.incDepthTrace()
        
        pass
        
        asqWx.logger.decDepthTrace()


    def OnDestroy(self) :
        """\
          void OnDestroy(void)
         
          Abstract- called by destructor, should be used to perform clean-up.
        """
        asqWx.logger.trace('window.OnDestroy')
        asqWx.logger.incDepthTrace()
        
        pass
        
        asqWx.logger.decDepthTrace()


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def OnPaint(self, event) :
        """\
          void OnPaint(wx.PaintEvent event)
         
          Control 'onPaint' event: Don't forget to call an handler
          that will actually process PAINT message, or else they will
          remain in application messaging loop.
         
          param  event                event to process
        """
        contxt = wx.PaintDC(self)
        event.Skip()


    def OnResize(self, event) :
        """\
          void OnResize(wx.SizeEvent event)
         
          Control 'onSize' event: Don't forget to call default handler to
          actually resize frame.
         
          param  event                event to process
        """
        # Continue looking for an event handler, in order
        # to reach the default handler
        buffer = event.GetSize()
        asqWx.logger.debug('window.OnResize (%d, %d)' % (buffer.width, buffer.height))
        event.Skip()


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def OnMouseMove(self, event) :
        """\
          void OnMouseMove(wx.MouseEvent event)
         
          Abstract- triggered when mouse is moved inside frame boundaries.
         
          param  event                event to process
        """
        buffer = event.GetPosition()
        asqWx.logger.debug('window.OnMouseMove (%d, %d)' % (buffer.x, buffer.y))
        event.Skip()


    def OnMouseEnter(self, event) :
        """\
          void OnMouseEnter(wx.MouseEvent event)
         
          Abstract- triggered when mouse enters frame.
         
          param  event                event to process
        """
        asqWx.logger.debug('window.OnMouseEnter')
        event.Skip()


    def OnMouseLeave(self, event) :
        """\
          void OnMouseLeave(wx.MouseEvent event)
         
          Abstract- BEWARE, OnMouseLeave is not always triggered when mouse
          simply leaves frame, this event will ONLY be FIRED IF a control
          inside frame is WAITING after a Mouse Up event (for example a
          button is pressed, but mouse is released OUTSIDE frame).
         
          param  event                event to process
        """
        asqWx.logger.debug('window.OnMouseLeave')
        event.Skip()


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # Getters - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # Setters - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # Properties  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # /class window - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

if '__main__' == __name__ :
  print __file__
  print __doc__


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -