#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
A bunch of common 'wx' constants definitions, highly useful.

Require
  Python        2.3.4
  wxPython      2.5.2
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.3 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

import  wx

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#
# Link of interest : KDE user interface guidelines
# http://developer.kde.org/documentation/standards/kde/style/basics/index.html
#
# All the needed item identifiers are defined here, some of them (actually
# very few) are missing from the wx lib.
# Before defining Id, please check wx "Standard event identifiers" list, and
# the "_core.py" file (wx directory)
#
# About void wxRegisterId(long id) :
#  Ensures that ids subsequently generated by NewId do not clash with the
#  given id. Set CurrentId start - usually at 100 (0x0064)
#
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

wx.RegisterId(0x0064)

ID_ABOUT                = wx.ID_ABOUT
ID_CLOSE                = wx.ID_CLOSE
ID_CLOSEALL             = wx.ID_CLOSE_ALL
ID_CUT                  = wx.ID_CUT
ID_COPY                 = wx.ID_COPY
ID_EXIT                 = wx.ID_EXIT
ID_FIND                 = wx.ID_FIND
ID_FINDNEXT             = wx.NewId()
ID_HELP                 = wx.ID_HELP
ID_NEW                  = wx.ID_NEW
ID_OPEN                 = wx.ID_OPEN
ID_OPENRECENT           = wx.NewId()
ID_PASTE                = wx.ID_PASTE
ID_PRINTSETUP           = wx.ID_PRINT_SETUP
ID_PRINTPREVIEW         = wx.ID_PREVIEW
ID_PRINT                = wx.ID_PRINT
ID_REDO                 = wx.ID_REDO
ID_REPLACE              = wx.ID_REPLACE
ID_REVERT               = wx.ID_REVERT
ID_SAVE                 = wx.ID_SAVE
ID_SAVEAS               = wx.ID_SAVEAS
ID_SELECTALL            = wx.ID_SELECTALL
ID_UNDO                 = wx.ID_UNDO



# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

if '__main__' == __name__ :
  print __file__
  print __doc__


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

del     wx

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -