#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
Defines a wrapping class around wx.App.

Require
  Python        2.3.4
  wxPython      2.5.2

Classes
  class         application(void) extends wx.App
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.3 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

import  wx

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#
# About error redirection
#
# When a python program hits an unhandled exception (bug!) in your program,
#  it aborts with a traceback that is useful in locating the source of the
#  problem. wxPython programs do the same, but with a twist. The traceback
#  is routed to stdio, which is captured in a nice GUI frame independent of
#  your program. If an exception shows up in an event handler, the
#  traceback is displayed, and your program continues on as best it can.
#  BUT, if the exception occurs while initializing your program, the
#  traceback will show up, and then your program will abort, taking the
#  stdio window (and your traceback) with it before even the fastest reader
#  can make sense of it.
#
# You can keep stdio from being hijacked by wxPython by providing a couple
#  of optional parameters when you instantiate your wxApp
#
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


class application(wx.App) :
    """\
      A class based on wx.App; It simply adds a class method which starts
      the application.
    """
    
  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
   
    def run(cls, redirect=False, filename=None) :
        """\
          int run(bool redirect, string filename)
          
          creates an 'application' object and fires up its "MainLoop"
          method. This class method can safely be used with any class
          derivated from 'application'.
          The 'redirect' parameter defines how wx traceback will be
          handled (whether or not it is displayed in its own window).
          If a 'filename' is provided, and 'redirect' is set to True, then
          the wx output will be written in that file.
          
          param  redirect             redirect output to a independent
                                        window. Defaults to False.
          param  filename             log file name.
                                        Defaults to None
          return                      application.MainLoop result
        """
        aWxApp = cls(redirect, filename)
        return aWxApp.MainLoop()


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    run = classmethod(run)

  # Constructor / Destructor  - - - - - - - - - - - - - - - - - - - - - - - - -
  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # Special methods - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # Getters - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # Setters - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # Properties  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # /class application  - - - - - - - - - - - - - - - - - - - - - - - - - - - -


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

if '__main__' == __name__ :
  print __file__
  print __doc__


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -