#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
Imports all needed stuff from "core" package units into package's
namespace.

Require
  Python        2.3.4
  wxPython      2.5.2

Functions
  void          bindEventTable(object window, list evtTable)
  void          unBindEventTable(object window, list evtTable)

Classes
  class         application(void) extends wx.App
  class         wildcard(string filter)
  class         wildcardList(sequence sequence) extends list
  class         window(void)
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.4 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# __all__ should contain the entire public API. It is intended to avoid
# accidentally exporting items that are not part of the API (such as
# library modules which were imported and used within the module).

__all__ = [
      'application',
      'eventTable',
      'identifiers',
      'wildcard',
      'window',
    ]

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

from    eventTable      import  bindEventTable, unBindEventTable

from    application     import  application
from    wildcard        import  wildcard, wildcardList
from    window          import  window

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

if '__main__' == __name__ :
  print __file__
  print __doc__


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -