#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
Performs version check (python and wxPython).
Sets up a message logger.

Require
  Python        2.3.4
  wxPython      2.5.2

Constants
  tuple         VERSION
  tuple         REQUIRED_PY
  tuple         REQUIRED_WX
  string        LOGGER_CONFIG
  string        LOGGER_NAME

Properties
  object        logger
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.8 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# __all__ should contain the entire public API. It is intended to avoid
# accidentally exporting items that are not part of the API (such as
# library modules which were imported and used within the module).

__all__ = [
      'controls',
      'core',
      'dialogs',
      'forms',
      'i18n'
    ]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

import  os
import  sys

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# asqWx module version
VERSION = (0, 0, 1)

# required interpreter and module version
REQUIRED_PY = ('2', '3', '4')
REQUIRED_WX = ('2', '5', '2')

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

py_reqStr = '.'.join(REQUIRED_PY)
wx_reqStr = '.'.join(REQUIRED_WX)

try :
  import  wx
except ImportError, e :
  sys.exit(
      '%s: error: failed to import wxPython module, please install '
      'wxPython %s (or later)' % (__file__, wx_reqStr)
    )

py_version = tuple(sys.version.split()[0].split('.'))
wx_version = tuple(wx.VERSION_STRING.split('.'))


if REQUIRED_PY > py_version or REQUIRED_WX > wx_version :
  sys.exit(
      '%s: error: version check failed, please update to '
      'Python %s and wxPython %s' % (__file__, py_reqStr, wx_reqStr)
    )


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# logging module is only available since python 2.3
import  logging
import  logging.config

import  py_netasq.commonlib.asqPath             as asqPath
import  py_netasq.commonlib.asqLogging          as asqLogging

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

LOGGER_DISABLED = not __debug__
# path to logger config file path *must* be absolute
LOGGER_CONFIG   = os.path.join(asqPath.directory(__file__), r'..\logConfig.ini')
LOGGER_NAME     = 'asqWx'


logging.setLoggerClass(asqLogging.customLogger)
logging.config.fileConfig(LOGGER_CONFIG)

logger = logging.getLogger(LOGGER_NAME)
logger.disabled = LOGGER_DISABLED


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

if '__main__' == __name__ :
  print __file__
  print __doc__
else :
  # check our customLogger logger
  logger.info('%s logger enabled', logger.name)

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

del py_reqStr
del wx_reqStr
del py_version
del wx_version

del asqPath
del logging.config
del logging
del wx
del sys
del os

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -