#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
A delphi building utility: Wrapper around versioning app (resModifier).

Since
  Python 2.2

Classes
  class         vrsCommand(void) extends basicCommand
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.2 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

import  os

import  py_netasq.commonlib.asqDebug            as asqDebug
import  py_netasq.commonlib.asqPath             as asqPath
import  py_netasq.commonlib.asqString           as asqString

from    py_netasq.delphi.building.basicCommand  import basicCommand
from    py_netasq.delphi.building.vrsTasks      import vrsTaskItem

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

if __name__ == '__main__' :
  print __file__
  print __doc__

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

class vrsCommand(basicCommand) :
    """\
      Wrapper around *.res modifier app. Settings have to be set through
      object's "task" (class vrsTaskItem) attribute.
      
      
      constructor vrsCommand(void)
      
      void      debug(int tab)
      var       run(object task, string codepage)
      
      property object  task
    """
    
    FMT_FILENAME = 'vrstasktmp%04u.ver'
    
    
  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # Constructor - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def __init__(self) :
        """\
          constructor vrsCommand(void)
          
          Create a new vrsCommand object.
        """
        super(vrsCommand, self).__init__()
        self._task     = vrsTaskItem(False, None)
        self.__tmpFile = None


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # Special methods - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def debug(self, tab=0) :
        """\
          void debug(int tab)
          
          Prints out the main attributes values. Each string to print, will
          be prepended with 'tab' space characters.
          
          param tab                   left margin width, defaults to 0
        """
        prefix  = ' ' * tab
        print asqDebug.debugValue('tmpFile', self.__tmpFile, tab)
        
        super(vrsCommand, self).debug(tab)


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  
    def run(self, task=None, codepage='cp1252') :
        """\
          var run(object task, string codepage)
          
          Launch current task, if a taskItem is provided, then it will
          permanently replace object's task.
          None value will be returned upon task success, any other value
          mean task failure.
          
          param task                  Task to execute, defaults to None
          param codepage              command output codepage, defaults
                                        to 'cp1252'
          return                      shell status
        """
        return super(vrsCommand, self).run(task, codepage)


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def _setUp(self) :
        """\
          void _setUp(void)
          
          Sets up (hence the function name) a few things before the task is
          actually executed.
          
          - Create (and fill) a temporary version file
          - append task's log file to listeners list
        """
        if self._task.isValid() :
          self.__tmpFile = self._setTmpFile(vrsCommand.FMT_FILENAME)
        else :
          self.__tmpFile = None
         
        super(vrsCommand, self)._setUp()


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def _tearDown(self) :
        """\
          void _tearDown(void)
          
          Clean up the mess caused by the '_setUp' procedure.
          
          - delete temporary version file
          - remove task's log file from listeners list
        """
        if self.__tmpFile is not None :
          os.remove(self.__tmpFile)
          
        super(vrsCommand, self)._tearDown()


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def _setTmpFile(self, format) :
        """\
          string _setTmpFile(string format)
          
          Create and fill a temporary version file (*.ver); a random filename
          is generated, it is unlikely to happen that a file with the same
          name would exist, but not impossible.
          
          param format                file name format
          return                      temp file name
        """
        result = asqString.formatRndString(format, 0, 9999)
        result = asqPath.normalize(asqPath.absolute(result, os.getcwd()))
        self._task.toFile(result)
        return result


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # Getters - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # Setters - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # Properties  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # class vrsCommand  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -