#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
A delphi building utility: Wrapper around Indigo Rose Setup Factory

Since
  Python 2.2

Classes
  class         sf6Command(void) extends basicCommand
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.2 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

import  os

import  py_netasq.commonlib.asqDebug            as asqDebug
import  py_netasq.commonlib.asqPath             as asqPath
import  py_netasq.commonlib.asqString           as asqString

from    py_netasq.delphi.building.basicCommand  import basicCommand
from    py_netasq.delphi.building.sf6Tasks      import sf6TaskItem

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

if __name__ == '__main__' :
  print __file__
  print __doc__

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

class sf6Command(basicCommand) :
    """\
      Wrapper around Indigo Rose Setup Factory. Settings have to be set
      through object's "task" (class sf6TaskItem) attribute.
      
      
      constructor sf6Command(void)
      
      void      debug(int tab)
      var       run(object task, string codepage)
      
      property object  task
    """
    
    FMT_FILENAME = 'sf6tasktmp%04u.ini'
    
    
  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # Constructor - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def __init__(self) :
        """\
          constructor sf6Command(void)
          
          Create a new sf6Command object.
        """
        super(sf6Command, self).__init__()
        self._task     = sf6TaskItem(False, None)
        self.__tmpFile = None


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # Special methods - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def debug(self, tab=0) :
        """\
          void debug(int tab)
          
          Prints out the main attributes values. Each string to print, will
          be prepended with 'tab' space characters.
          
          param tab                   left margin width, defaults to 0
        """
        prefix  = ' ' * tab
        print asqDebug.debugValue('tmpFile', self.__tmpFile, tab)
        
        super(sf6Command, self).debug(tab)


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def _setUp(self) :
        """\
          void _setUp(void)
          
          Sets up (hence the function name) a few things before the task is
          actually executed.
          
          - Create (and fill) a temporary unattended build file
          - append task's log file to listeners list
        """
        if self._task.isValid() :
          self.__tmpFile = self._setTmpFile(sf6Command.FMT_FILENAME)
        else :
          self.__tmpFile = None
         
        super(sf6Command, self)._setUp()


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def _tearDown(self) :
        """\
          void _tearDown(void)
          
          Clean up the mess caused by the '_setUp' procedure.
          
          - delete temporary unattended build file
          - remove task's log file from listeners list
        """
        if self.__tmpFile is not None :
          os.remove(self.__tmpFile)
          
        super(sf6Command, self)._tearDown()


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def _setTmpFile(self, format) :
        """\
          string _setTmpFile(string format)
          
          Create and fill a temporary unattended build file (*.ini); a random
          filename is generated, it is unlikely to happen that a file with
          the same name would exist, but not impossible.
          
          param format                file name format
          return                      temp file name
        """
        result = asqString.formatRndString(format, 0, 9999)
        result = asqPath.normalize(asqPath.absolute(result, os.getcwd()))
        self._task.toFile(result)
        return result


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # Getters - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # Setters - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # Properties  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # class sf6Command  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -