#!/usr/bin/env python

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
Define a mail task; settings for reporting mail.

Since
  Python 2.2.2

Classes
  class         mailTaskItem(bool enabled) extends taskItem
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.5 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

import  getpass
import  os
from    email.MIMEMultipart                     import MIMEMultipart
from    email.MIMEText                          import MIMEText

import  py_netasq.commonlib.asqMail             as asqMail
from    py_netasq.delphi.building.basicTasks    import taskItem, taskList

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

if __name__ == '__main__' :
  print __file__
  print __doc__


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

class mailTaskItem(taskItem) :
    """\
      A mail task: send logfile to defined recipients, "failure" or
      "success" attributes will be used as mail subjects, if building
      process either failed or succeed. if "sender" is not set, then
      the "login name" of the current user will be used.
      
      
      constructor mailTaskItem(bool enabled, string recipients)
      
      bool      isValid(void)
      object    toMessage(bool successful, string text)
      
      property string sender     : mail sender
      property string recipients : mail recipients
      property string failure    : mail subject "build failed"
      property string success    : mail subject "build success"
    """
    
    TASKTYPE      = "mailTask"
    # used if no sender is given
    SENDER_DOMAIN = "netasq.com"
    
  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # Constructor - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
    
    def __init__(self, enabled=True, recipients=None) :
        """\
          constructor mailTaskItem(bool enabled, string recipients)
          
          Create a new mail task. all properties are set to 'None' value.
          
          param enabled               is task enabled, defaults to True
          param recipients            mail recipients, defaults to None
        """
        super(mailTaskItem, self).__init__(enabled)
        self._tasktype   = mailTaskItem.TASKTYPE
        self._compatWith = (mailTaskItem.TASKTYPE,)
        # new attributes
        self._attributes.append('sender')
        self._attributes.append('recipients')
        self._attributes.append('success')
        self._attributes.append('failure')
        # set new attributes to None
        self.reset(False)
        self.recipients  = recipients


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def isValid(self) :
        """\
          bool isValid(void)
          
          Tells whether or not the task is "valid", id est, if mandatory
          attributes are set; an empty taskItem is not valid, but an
          invalid taskItem may not be empty ;)
          
          return                      is task valid
        """
        #~ if self.isEmpty() :
        if not self :
          return False
        elif not self._isValidString('recipients') :
          return False
        else :
          return True


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def toMessage(self, successful=False, text='') :
        """\
          object toMessage(bool successful, string text)
          
          Build a MIMEText object with mail task settings; 'successful'
          tells which subject to use ("success" or "failure"). If task is
          not valid, then None will be returned.
          
          param succesful             which subject to use, defaults to False
          param text                  mail short text, defaults to ''
          return                      a email.Message object
        """
        if not self.isValid() :
          return None
        if successful :
          subject = self.success
        else :
          subject = self.failure
        if not self._isValidString('sender') :
          sender = '%s@%s' % (getpass.getuser(), self.SENDER_DOMAIN)
        else :
          sender = self.sender
        
        result = MIMEMultipart('mixed')
        asqMail.setupMessage(result, sender, self.recipients, subject)
        
        if text         : result.attach(MIMEText(text))
        if self.logfile : asqMail.attachTextFileTo(result, self.logfile)
        
        return result


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # class mailTaskItem  - - - - - - - - - - - - - - - - - - - - - - - - - - - -


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -