#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
Building utility: send an email using task's settings.

Since
  Python 2.2

Classes
  class         mailCommand(void) extends basicCommand
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.3 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

import  smtplib

import  py_netasq.commonlib.asqMail             as asqMail

from    py_netasq.delphi.building.basicCommand  import basicCommand
from    py_netasq.delphi.building.mailTasks     import mailTaskItem

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

if __name__ == '__main__' :
  print __file__
  print __doc__


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


class mailCommand(basicCommand) :
    """\
      Wrapper around cvs client. Settings have to be set through object's
      "task" (class cvsTaskItem) attribute.
      
      
      constructor mailCommand(void)
      
      void      debug(int tab)
      var       run(string sender, bool successful, object task)
      
      property object  task
      property string  host
    """
    
    # netasq smtp host address
    SMTP_HOST  = '10.0.0.3'
    
  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # Constructor - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def __init__(self) :
        """\
          constructor mailCommand(void)
          
          Create a new mailCommand object.
        """
        super(mailCommand, self).__init__()
        self._task     = mailTaskItem(False)
        self.__host    = mailCommand.SMTP_HOST


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # Special methods - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  
    def run(self, successful, text='', task=None) :
        """\
          var run(string sender, bool successful, object task)
          
          Launch current task, if a taskItem is provided, then it will
          permanently replace object's task. 'successful' is used to select
          accurate mail subject, whether the build process failed, or did
          sucess.
          None value will be returned upon task success, any other value
          mean task failure.
          
          param sender                Mail sender
          param successful            select mail subject
          param task                  Task to execute, defaults to None
          return                      shell status
        """
        if task is not None :
          self._setTask(task)
        
        if not self.__host or not self._task.isValid() :
          return -1
         
        try :
          message = self._task.toMessage(successful, text)
          asqMail.sendMailMessage(message, self.__host)
        except smtplib.SMTPException :
          return -1
        else :
          return None


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # Getters - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def _getHost(self) :
        """\
          string _getHost(void)
          
          Returns the SMTP host address to use.
          
          return                      SMTP host address
        """
        return self.__host


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # Setters - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def _setHost(self, value) :
        """\
          void _setHost(var value)
          
          Set SMTP host address to use.
          
          param value                 SMTP host address
        """
        if not isinstance(value, basestring) :
          self.__host = None
        else :
          self.__host = value


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # Properties  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    host     = property(
                doc  = "SMTP server address",
                fset = _setHost,
                fget = _getHost,
                fdel = None )

  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # class mailCommand - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -