#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
A delphi building utility: Wrapper for delete tasks.
Actually, this one does not really behave as a basicCommand, since no shell
command are used

Since
  Python 2.2

Classes
  class         delCommand(void) extends basicCommand
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.8 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

import  os
import  shutil

import  py_netasq.commonlib.asqDebug            as asqDebug
import  py_netasq.commonlib.asqPath             as asqPath

from    py_netasq.commonlib.asqWin              import windowsCmd
from    py_netasq.delphi.building.basicCommand  import basicCommand
from    py_netasq.delphi.building.delTasks      import delTaskItem

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

if __name__ == '__main__' :
  print __file__
  print __doc__

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

class delCommand(basicCommand) :
    """\
      Wrapper for raw tasks. Settings have to be set through object's "task"
      (class delTaskItem) attribute.
      
      
      constructor delCommand(void)
      
      void      debug(int tab)
      var       run(object task, string codepage)
      
      property object  task
    """

  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # Constructor - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def __init__(self) :
        """\
          constructor delCommand(void)
          
          Create a new delCommand object.
        """
        super(delCommand, self).__init__()
        self._task = delTaskItem(False)


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # Special methods - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def debug(self, tab=0) :
        """\
          void debug(int tab)
          
          Prints out the main attributes values. Each string to print, will
          be prepended with 'tab' space characters.
          
          param tab                   left margin width, defaults to 0
        """
        prefix  = ' ' * tab
        print '%s[ task debug  ] - - - - - - - - - - - - - -' % (prefix,)
        self._task.debug(1 + tab)
        print '%s[ CMD line    ] - - - - - - - - - - - - - -' % (prefix,)
        print '%s %s' % (prefix, str(self._task))


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  
    def run(self, task=None, codepage=windowsCmd.DEFAULT_CODEPAGE) :
        """\
          var run(object task, string codepage)
          
          Launch current task, if a taskItem is provided, then it will
          permanently replace object's task.
          None value will be returned upon task success, any other value
          mean task failure.
          
          param task                  Task to execute, defaults to None
          param codepage              command output codepage, defaults
                                        to windowsCmd.DEFAULT_CODEPAGE
          return                      shell status
        """
        if task is not None :
          self._setTask(task)
        
        try :
          self._setUp()
          # clears last command's execution output
          self._resetCmdOutput()
          return self._delete()
        finally :
          self._tearDown()
    
    
  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def _delete(self) :
        """\
          void _delete(void)
          
          Delete file / directory given by 'target' property of current
          task. 'None' is returned if execution was succesful, any other
          value mean failure.
        """
        assert self._task.isValid(), "no valid command supplied"
        
        self._record(str(self._task), False)
        try :
          _target = self._task.target
          # if target does not exist nothing happens
          if not os.path.exists(_target) :
            pass
          elif os.path.isfile(_target) :
            os.chmod(_target, 0777)
            os.remove(_target)
          elif os.path.isdir(_target) :
            asqPath.emptyDirs(_target, True)
            shutil.rmtree(_target)
          else :
            assert False,                                                   \
                   "item is not a file, neither a directory %s" % (_target,)
        except Exception, e :
          self._record(str(e))
          return 1
        else :
          return None


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # Getters - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # Setters - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # Properties  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # class delCommand  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -