#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
A delphi building utility: Wrapper around cvs client.

Since
  Python 2.2

Classes
  class         cvsCommand(void) extends basicCommand
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.2 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

import  os

import  py_netasq.commonlib.asqDebug            as asqDebug

from    py_netasq.delphi.building.basicCommand  import basicCommand
from    py_netasq.delphi.building.cvsTasks      import cvsTaskItem

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

if __name__ == '__main__' :
  print __file__
  print __doc__


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


class cvsCommand(basicCommand) :
    """\
      Wrapper around cvs client. Settings have to be set through object's
      "task" (class cvsTaskItem) attribute.
      
      
      constructor cvsCommand(void)
      
      void      debug(int tab)
      var       run(object task, string codepage)
      
      property object  task
    """
    
    ENV_CVS_RSH     = 'CVS_RSH'

  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # Constructor - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def __init__(self) :
        """\
          constructor cvsCommand(void)
          
          Create a new cvsCommand object.
        """
        super(cvsCommand, self).__init__()
        self._task     = cvsTaskItem(False, None)
        # to be certain that properties are available in object's scope
        self.__initCwd = None
        self.__initRsh = None


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # Special methods - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def debug(self, tab=0) :
        """\
          void debug(int tab)
          
          Prints out the main attributes values. Each string to print, will
          be prepended with 'tab' space characters.
          
          param tab                   left margin width, defaults to 0
        """
        prefix  = ' ' * tab
        currRsh = os.getenv(cvsCommand.ENV_CVS_RSH, None)
        
        print asqDebug.debugValue('currCwd', os.getcwd()   , tab)
        print asqDebug.debugValue('currRsh', currRsh       , tab)
        print asqDebug.debugValue('initCwd', self.__initCwd, tab)
        print asqDebug.debugValue('initRsh', self.__initRsh, tab)
        
        super(cvsCommand, self).debug(tab)


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def _setUp(self) :
        """\
          void _setUp(void)
          
          Sets up (hence the function name) a few things before the task is
          actually executed.
          
          - Some cvs command ('update') has to be executed from within the
           destination directory, so we switch the current directory; If
           detination dir does not exist, it will be created, but an
           exception may be raised if directory creation is impossible
           (for MS windows: give a wrong drive letter).
          - CVS_RSH Environnement value has to be properly set.
          - append task's log file to listeners list
        """
        destDir = self._task.destdir
        cvs_rsh = self._task.cvsrsh
        
        if destDir is None :
          self.__initCwd = None
        else :
          self.__initCwd = os.getcwd()
          if not os.path.isdir(destDir) : os.mkdir(destDir)
          os.chdir(destDir)
          
        if cvs_rsh is None :
          self.__initRsh = None
        else :
          self.__initRsh = os.getenv(cvsCommand.ENV_CVS_RSH, None)
          os.putenv(cvsCommand.ENV_CVS_RSH, cvs_rsh)
          
        super(cvsCommand, self)._setUp()


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def _tearDown(self) :
        """\
          void _tearDown(void)
          
          Clean up the mess caused by the '_setUp' procedure.
          
          - switch back directory
          - restore previous CVS_RSH value
          - remove task's log file from listeners list
        """
        if self.__initCwd is not None :
          os.chdir(self.__initCwd)
        if self.__initRsh is not None :
          os.putenv(cvsCommand.ENV_CVS_RSH, self.__initRsh)
          
        super(cvsCommand, self)._tearDown()


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # Getters - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # Setters - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # Properties  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # class cvsCommand  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -