#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
A delphi building utility: generic build task execution.

Since
  Python 2.2

Classes
  class         basicCommand(void) extends asqWin.windowsCmd
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.3 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

import  py_netasq.commonlib.asqDebug            as asqDebug

from    py_netasq.commonlib.asqWin              import windowsCmd
from    py_netasq.delphi.building.basicTasks    import taskItem

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

if __name__ == '__main__' :
  print __file__
  print __doc__

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

class basicCommand(windowsCmd) :
    """\
      Generic build task execution. Settings have to be set through
      command's "task" (class TaskItem) attribute.
      
      
      constructor basicCommand(void)
      
      void      debug(int tab)
      var       run(object task, string codepage)
      
      property object  task
    """

  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # Constructor - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def __init__(self) :
        """\
          constructor basicCommand(void)
          
          Create a new basicCommand object.
        """
        super(basicCommand, self).__init__()
        self._task    = taskItem(False)
        self._logFile = None


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # Special methods - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def debug(self, tab=0) :
        """\
          void debug(int tab)
          
          Prints out the main attributes values. Each string to print, will
          be prepended with 'tab' space characters.
          
          param tab                   left margin width, defaults to 0
        """
        prefix  = ' ' * tab
        print '%s[ task debug  ] - - - - - - - - - - - - - -' % (prefix,)
        self._task.debug(1 + tab)
        print '%s[ CMD line    ] - - - - - - - - - - - - - -' % (prefix,)
        print '%s %s' % (prefix, self._task.toCmdLine())


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  
    def run(self, task=None, codepage=windowsCmd.DEFAULT_CODEPAGE) :
        """\
          var run(object task, string codepage)
          
          Launch current task, if a taskItem is provided, then it will
          permanently replace object's task.
          None value will be returned upon task success, any other value
          mean task failure.
          
          param task                  Task to execute, defaults to None
          param codepage              command output codepage, defaults
                                        to windowsCmd.DEFAULT_CODEPAGE
          return                      shell status
        """
        if task is not None :
          self._setTask(task)
        
        try :
          self._setUp()
          command = self._task.toCmdLine()
          return self._run(command, codepage)
        finally :
          self._tearDown()


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def _setUp(self) :
        """\
          void _setUp(void)
          
          Sets up (hence the function name) a few things before the task is
          actually executed.
          
          - append task's log file to listeners list
        """
        if self._task.logfile is None :
          self._logFile = None
        else :
          self._logFile = file(self._task.logfile, 'a')
          self.listeners.append(self._logFile)


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  
    def _run(self, command, codepage) :
        """\
          var _run(string command, string codepage)
          
          Execute given 'command' and return shell status.
          
          param command               command to execute
          param codepage              command output codepage
          return                      shell status
        """
        #~ self.debug()
        return super(basicCommand, self).run(command, codepage)


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def _tearDown(self) :
        """\
          void _tearDown(void)
          
          Clean up the mess caused by the '_setUp' procedure.
          
          - remove task's log file from listeners list
        """
        if self._logFile is not None :
          self.listeners.remove(self._logFile)
          self._logFile.close()
          self._logFile = None


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # Getters - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # Setters - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def _setTask(self, value) :
        """\
          void _setTask(object value)
          
          Set current task object using given task 'value' as a source.
          
          param value                 task to copy attributes from
        """
        self._task.assign(value)
        self._task.expandPaths()


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # Properties  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    task     = property(
                doc  = "task item to run",
                fset = _setTask,
                fget = None,
                fdel = None )

  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # class basicCommand  - - - - - - - - - - - - - - - - - - - - - - - - - - - -


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -