#!/usr/bin/env python

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
asqTypes (basic) test suite
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.5 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

import  unittest

import  py_netasq.commonlib.asqTypes                    as asqTypes

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


class test_asqTypes(unittest.TestCase) :

    def testProtos1(self) :
        """\
          check if missing parameters or invalid types do raise exceptions.
        """
        self.assertRaises(TypeError, asqTypes.asBoolean)
        self.assertRaises(TypeError, asqTypes.asBoolean, '', 'a')
        self.assertRaises(TypeError, asqTypes.asInteger)
        self.assertRaises(TypeError, asqTypes.asInteger, '', 'a')
        self.assertRaises(TypeError, asqTypes.isNonEmptyInstance)
        self.assertRaises(TypeError, asqTypes.isNonEmptyInstance, '')


    def testAsBoolean1(self) :
        """\
          check asBoolean() results.
        """
        self.assertEqual(True , asqTypes.asBoolean(1))
        self.assertEqual(False, asqTypes.asBoolean(0))
        self.assertEqual(False, asqTypes.asBoolean(None))
        self.assertEqual(False, asqTypes.asBoolean('None'))
        self.assertEqual(False, asqTypes.asBoolean('False'))
        self.assertEqual(False, asqTypes.asBoolean(''))
        self.assertEqual(True , asqTypes.asBoolean('True'))
        self.assertEqual(True , asqTypes.asBoolean('arf'))


    def testAsInteger1(self) :
        """\
          check asInteger() results.
        """
        self.assertEqual(1, asqTypes.asInteger(1))
        self.assertEqual(1, asqTypes.asInteger('1'))
        self.assertEqual(0, asqTypes.asInteger('08', radix=0))
        self.assertEqual(8, asqTypes.asInteger('08', radix=10))
        self.assertEqual(0, asqTypes.asInteger('', default=0))
        self.assertEqual(0, asqTypes.asInteger(None, default=0))


    def testIsNonEmptyInstance1(self) :
        """\
          check isNonEmptyInstance() results.
        """
        buffer = 'aa'
        self.assert_( asqTypes.isNonEmptyInstance(buffer, basestring) )
        self.failIf( asqTypes.isNonEmptyInstance('', basestring) )


  # /class test_asqTypes  - - - - - - - - - - - - - - - - - - - - - - - - - - -


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

if '__main__' == __name__ :
    unittest.main()

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -