#!/usr/bin/env python

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
asqSequence (basic) test suite
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.4 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

import  unittest

import  py_netasq.commonlib.asqSequence                 as asqSequence

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


class test_asqSequence(unittest.TestCase) :

    def testProtos1(self) :
        """\
          check if missing parameters or invalid types do raise exceptions.
        """
        self.assertRaises(TypeError, asqSequence.stuffSequence)
        self.assertRaises(TypeError, asqSequence.intersection)
        self.assertRaises(TypeError, asqSequence.difference)
        self.assertRaises(TypeError, asqSequence.unique)


    def testStuffSequence1(self) :
        """\
          check stuffSequence() result.
        """
        buffer = ['0', '1', '3', '7']
        ersatz = list(buffer)
        asqSequence.stuffSequence(ersatz, len(buffer), None)
        self.assertEqual(buffer, ersatz)
        
        buffer = ['0', '1', '3', '7']
        asqSequence.stuffSequence(buffer, 2*len(buffer), 0)
        self.assertEqual(buffer, ['0', '1', '3', '7', 0, 0, 0, 0])


    def testIntersection1(self) :
        """\
          check intersection() result.
        """
        buffer = ['0', '1', '3', '7']
        self.assertEqual( buffer, asqSequence.intersection(buffer) )
        
        buffer = ('0', '1', '3', '7')
        self.assertEqual( list(buffer), asqSequence.intersection(buffer) )
        
        buffer = { 'a': 1, 'b': 2, 'c':2, 'd': [5, 6], 'e': {1:0} }
        self.assertEqual( buffer.keys(), asqSequence.intersection(buffer) )
        
        buffer = 'cfabcdef'
        self.assertEqual( list(buffer), asqSequence.intersection(buffer) )
        
        a = ('0', '1', '3', '7')
        b = ['5', '2', '3', '0']
        self.assertEqual( ['0', '3'], asqSequence.intersection(a, b) )
        
        a = ('0', '1', '3', '7')
        b = ['5', '2', '3', '0']
        c = {'5': 1, '4': 2, '3': 2, '2': ('a',), '1': [5, 6], '0': {1:0} }
        self.assertEqual( ['0', '3'], asqSequence.intersection(a, b, c) )
        
        a = {'5': 1, '4': 2, '3': 2, '2': ('a',), '1': [5, 6], '7': {1:0} }
        b = ['5', '2', '3', '0']
        # we can't guess the dictionnaty key order
        buffer = asqSequence.intersection(a, b)
        buffer.sort()
        self.assertEqual( ['2', '3', '5'], buffer )
        
        a = 'cfabcdef'
        b = 'cdfghi'
        # strings are sequences too
        self.assertEqual( ['c', 'f', 'c', 'd', 'f'], asqSequence.intersection(a, b))
        
        a = { 'a': 1, 'b': 2, 'c':2, 'd': [5, 6], 'e': {1:0} }
        b = 'cfabcdef'
        buffer = asqSequence.intersection(a, b)
        buffer.sort()
        self.assertEqual( ['a', 'b', 'c', 'd', 'e'], buffer)



    def testDifference1(self) :
        """\
          check difference() result.
        """
        buffer = ['0', '1', '3', '7']
        self.assertEqual( buffer, asqSequence.difference(buffer) )
        
        buffer = ('0', '1', '3', '7')
        self.assertEqual( list(buffer), asqSequence.difference(buffer) )
        
        buffer = { 'a': 1, 'b': 2, 'c':2, 'd': [5, 6], 'e': {1:0} }
        self.assertEqual( buffer.keys(), asqSequence.difference(buffer) )
        
        buffer = 'cfabcdef'
        self.assertEqual( list(buffer), asqSequence.difference(buffer) )
        
        a = ('0', '1', '3', '7')
        b = ['5', '2', '3', '0']
        self.assertEqual( ['1', '7'], asqSequence.difference(a, b) )
        
        a = ('0', '1', '3', '7')
        b = ['5', '2', '3', '0']
        c = {'5': 1, '4': 2, '3': 2, '2': ('a',), '1': [5, 6], '0': {1:0} }
        self.assertEqual( ['7'], asqSequence.difference(a, b, c) )
        
        a = {'5': 1, '4': 2, '3': 2, '2': ('a',), '1': [5, 6], '7': {1:0} }
        b = ['5', '2', '3', '0']
        # we can't guess the dictionnaty key order
        buffer = asqSequence.difference(a, b)
        buffer.sort()
        self.assertEqual( ['1', '4', '7'], buffer )
        
        a = 'cfabcdef'
        b = 'cdfghi'
        # strings are sequences too
        self.assertEqual( ['a', 'b', 'e'], asqSequence.difference(a, b))
        
        a = { 'a': 1, 'b': 2, 'c':2, 'd': [5, 6], 'e': {1:0} }
        b = 'cfabcdef'
        buffer = asqSequence.difference(a, b)
        buffer.sort()
        self.assertEqual( [], buffer)



    def testUnique1(self) :
        """\
          check unique() result.
        """
        self.assertEqual( [1, 2, 3] , asqSequence.unique([1, 2, 1, 3, 1, 2, 3]) )
        self.assertEqual( ['a', 'b', 'c'] , asqSequence.unique('abacabc') )
        
        buffer = ([1, 2], (5, 6), [2, 3], [1, 2], (1,3))
        self.assertEqual(
            [ [1, 2], (5, 6), [2, 3], (1, 3) ] ,
            asqSequence.unique(buffer, True)
          )
         
        self.assertEqual(
            [ [1, 2], [2, 3], (1, 3), (5, 6)] ,
            asqSequence.unique(buffer, False)
          )


  # /class test_asqSequence - - - - - - - - - - - - - - - - - - - - - - - - - -


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

if '__main__' == __name__ :
    unittest.main()

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -