#!/usr/bin/env python

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
asqPath (basic) test suite
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.8 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

import  os
import  unittest

import  py_netasq.commonlib.asqPath                     as asqPath

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


class test_asqPath(unittest.TestCase) :

    def testProtos1(self) :
        """\
          check if missing parameters or invalid types do raise exceptions.
        """
        self.assertRaises(TypeError, asqPath.absolute)
        self.assertRaises(TypeError, asqPath.normalize)
        self.assertRaises(TypeError, asqPath.directory)
        self.assertRaises(TypeError, asqPath.makeDir)
        self.assertRaises(TypeError, asqPath.changeDir)
        self.assertRaises(TypeError, asqPath.emptyDirs)
        self.assertRaises(TypeError, asqPath.emptyDirectory)
        self.assertRaises(TypeError, asqPath.delete)


    def testAbsolute1(self) :
        """\
          check absolute() results.
        """
        buffer = r'c:\temp'
        self.assertEqual(buffer, asqPath.absolute(buffer, None))
        
        buffer = r'c:\temp'
        self.assertEqual(buffer, asqPath.absolute(buffer, r'c:\.'))
        
        buffer = r'..\..\.\temp'
        self.assertEqual(r'c:\temp', asqPath.absolute(buffer, r'c:\.'))
        
        buffer = r'..\.\temp'
        self.assertEqual(r'c:\temp', asqPath.absolute(buffer, r'c:\windows'))
        
        buffer = r'..\.\.\blu\..\temp'
        self.assertEqual(r'c:\windows\temp', asqPath.absolute(buffer, r'c:\windows\arf'))
        
        buffer = './truc/*/*.dll'
        self.assertEqual(r'c:\truc\*\*.dll', asqPath.absolute(buffer, r'c:\.'))


    def testNormalize1(self) :
        """\
          check normalize() results.
        """
        # the following should be rewritten to be platform dependant...
        self.assertEqual(r'c:\windows\temp', asqPath.normalize(r'C:\WINDOWS\TEMP'))
        self.assertEqual(r'c:\windows\temp', asqPath.normalize(r'c:\windows/temp'))
        self.assertEqual(r'c:\windows\temp', asqPath.normalize(r'c:\windows\./temp'))
        self.assertEqual(r'c:\windows\temp', asqPath.normalize(r'c:\WINDOWS\temp\.././temp'))
        self.assertEqual(r'truc\*\*.dll', asqPath.normalize('./truc/*/*.dll'))


    def testDirectory1(self) :
        """\
          check directory() results.
        """
        # the following should be rewritten to be platform dependant...
        self.assertEqual(r'c:\windows\temp', asqPath.directory(r'C:\WINDOWS\TEMP'))
        self.assertEqual(r'c:\windows', asqPath.directory(r'C:\WINDOWS\explorer.exe'))


    def testDelete1(self) :
        """\
          check delete() behavior and results.
        """
        self.assertRaises(OSError, asqPath.delete, 'truc/*/*.dll', force=False)


    def testSuite1(self) :
        """\
          check makeDir(), emptyDirs() and delete()
        """
        asqPath.makeDir('dumb/dumb/dumb', 0777)
        aFile = file('dumb/dumb.txt', 'w+')
        aFile.close()
        os.chmod('dumb/dumb.txt', 0000)
        self.assertRaises(OSError, asqPath.emptyDirs, 'dumb', False)
        self.assertRaises(OSError, asqPath.delete, 'dumb', False)
        asqPath.emptyDirs('dumb', True)
        aFile = file('dumb/dumb.txt', 'w+')
        aFile.close()
        os.chmod('dumb/dumb.txt', 0000)
        asqPath.delete('dumb', True)
        self.assert_(not os.path.exists('dumb'))


    def testSuite2(self) :
        """\
          check makeTmpFile() and delete()
        """
        buffer = asqPath.makeTmpFile()
        self.assert_(os.path.isabs(buffer))
        self.assert_(os.path.exists(buffer))
        self.assert_(os.path.isfile(buffer))
        asqPath.delete(buffer, True)
        self.assert_(not os.path.exists(buffer))


    def testSuite3(self) :
        """\
          check makeDir(), emptyDirectory() and delete()
        """
        asqPath.makeDir('dumb/dumb/dumb', 0777)
        aFile = file('dumb/dumb.txt', 'w+')
        aFile.close()
        aFile = file('dumb/dumb/dumb.txt', 'w+')
        aFile.close()
        aFile = file('dumb/dumb/dumb/dumb.txt', 'w+')
        aFile.close()
        
        os.chmod('dumb/dumb.txt', 0000)
        os.chmod('dumb/dumb/dumb.txt', 0000)
        os.chmod('dumb/dumb/dumb/dumb.txt', 0000)
        
        self.assertRaises(OSError, asqPath.emptyDirectory, 'dumb', False)
        self.assertRaises(OSError, asqPath.emptyDirs, 'dumb', False)
        
        asqPath.emptyDirectory('dumb', True)
        self.assertFalse( bool(os.listdir('dumb')) )
        
        self.assert_(os.path.exists('dumb'))
        asqPath.delete('dumb', True)
        self.assert_(not os.path.exists('dumb'))


  # /class test_asqPath - - - - - - - - - - - - - - - - - - - - - - - - - - - -


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

if '__main__' == __name__ :
    unittest.main()

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -