#!/usr/bin/env python

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
asqMapping (basic) test suite
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.9 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

import  unittest

from    py_netasq.commonlib             import asqMapping

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

class test_asqMapping(unittest.TestCase) :

    def testProtos1(self) :
        """\
          check if missing parameters or invalid types do raise exceptions.
        """
        self.assertRaises(TypeError, asqMapping.invertion)
        self.assertRaises(TypeError, asqMapping.intersection)
        self.assertRaises(TypeError, asqMapping.difference)
        self.assertRaises(TypeError, asqMapping.intersectKeys)
        self.assertRaises(TypeError, asqMapping.filterKeys)
        self.assertRaises(TypeError, asqMapping.extractItem)
        self.assertRaises(TypeError, asqMapping.filterDict)


    def testInvertion1(self) :
        """\
          check invertion() results.
        """
        buffer = { 'a': 1, 'b': 2, 'c':2, 'd': [5, 6], 'e': {1:0} }
        # note : dict() values can't be used as key
        self.assertEqual(
            { 1: 'a', 2: 'b' } ,
            asqMapping.invertion(buffer, extend=False)
          )
        self.assertEqual(
            { 1: 'a', 2: ['c', 'b'], 5: 'd', 6: 'd' } ,
            asqMapping.invertion(buffer, extend=True)
          )
        self.assertEqual(
            { 'a': 1, 'b': 2, 'c':2, 'd': [5, 6] } ,
            asqMapping.invertion( asqMapping.invertion(buffer, True) , True)
          )


    def testIntersection1(self) :
        """\
          check intersection() results.
        """
        X = { 'a': 1, 'b': 2, 'c': 2, 'd': [5, 6], 'e': {1:0} }
        Y = { 'a': '1', 'b' : 2, 'd': [5, 6], 'e': {1:0} }
        Z = { 'e': {1:0} }
        
        self.assertEqual( X , asqMapping.intersection(X) )
        self.assertEqual(
            { 'b': 2, 'd': [5, 6], 'e': {1:0} } ,
            asqMapping.intersection(X, Y)
          )
        self.assertEqual(
            { 'e': {1:0} } ,
            asqMapping.intersection(X, Y, Z)
          )


    def testDifference1(self) :
        """\
          check difference() results.
        """
        X = { 'a': 1, 'b': 2, 'c': 2, 'd': [5, 6], 'e': {1:0} }
        Y = { 'a': '1', 'b' : 2, 'd': [5, 6], 'e': {1:0} }
        Z = { 'e': {1:0} }
        
        self.assertEqual( X , asqMapping.difference(X) )
        self.assertEqual(
            { 'a': 1, 'c': 2 } ,
            asqMapping.difference(X, Y)
          )
        self.assertEqual(
            { 'a': 1, 'c': 2 } ,
            asqMapping.difference(X, Y, Z)
          )


    def testIntersectKeys1(self) :
        """\
          check intersectKeys() results.
        """
        a = { 'zope':'zzz', 'python':'rocks' }
        b = { 'python':'rocks', 'perl':'$' }
        c = { 'java' : 'public static void' }
        
        self.assertEqual( a.keys() , asqMapping.intersectKeys(a) )
        self.assertEqual(['python'], asqMapping.intersectKeys(a, b))
        self.assertEqual([], asqMapping.intersectKeys(a, b, c))


    def testFilterKeys1(self) :
        """\
          check filterKeys() results.
        """
        a = { 'a' : 0, 'b' : 2, 'z' : 8 }
        asqMapping.filterKeys(a, (), True)
        self.assertEqual( a, { 'a' : 0, 'b' : 2, 'z' : 8 } )
          
        asqMapping.filterKeys(a, a.keys(), False)
        self.assertEqual( a, { 'a' : 0, 'b' : 2, 'z' : 8 } )
        
        asqMapping.filterKeys(a, (), False)
        self.assertEqual( a, {} )
        
        a = { 'a' : 0, 'b' : 2, 'z' : 8 }
        asqMapping.filterKeys(a, ('a', 'b'), False)
        self.assertEqual( { 'a' : 0, 'b' : 2 } , a )
        
        a = { 'a' : 0, 'b' : 2, 'z' : 8 }
        asqMapping.filterKeys(a, ('a', 'b'), True)
        self.assertEqual( { 'z' : 8 } , a )


    def testExtractItem1(self) :
        """\
          check extractItem() results.
        """
        buffer = { 'a': 1, 'b': 2, 'c': 2, 'd': [5, 6], 'e': {1:0} }
        self.assertEqual( [5, 6], asqMapping.extractItem(buffer, 'd', None) )
        self.failIf('d' in buffer)
        
        buffer = [ ('a', 1), ('b', 2), ('d', [5, 6]), ('e', {1 : 0}) ]
        self.assertEqual( {1 : 0} , asqMapping.extractItem(buffer, 'e', None) )
        self.assertEqual( None , asqMapping.extractItem(buffer, 'e', None) )
        
        
        a = { 'a' : 0, 'b' : 2, 'z' : 8 }
        self.assertEqual( 8, asqMapping.extractItem(a, 'z', None) )
        self.failIf('z' in a)
        self.assertEqual( None, asqMapping.extractItem(a, 'z', None) )


    def testFilterDict1(self) :
        """\
          check valueFilter() results.
        """
        buffer = { 'a': 1, 'b': 2, 'c': 2, 'd': [5, 6], 'e': {1:0} }
        self.assertEqual( buffer, asqMapping.filterDict(None, buffer) )
        
        buffer = { 'a': 1, 'b': 2, 'c': None, 'd': [], }
        self.assertEqual( { 'a': 1, 'b': 2 }, asqMapping.filterDict(None, buffer) )
        self.assertEqual( { 'b': 2, 'a': 1 }, asqMapping.filterDict(None, buffer) )
        
        buffer = { 'a': 1, 'b': 2, 'c': 2, 'd': -1, 'e': 0 }
        callbk = lambda x : 1 < x
        self.assertEqual( { 'b': 2, 'c': 2 }, asqMapping.filterDict(callbk, buffer) )
        


  # /class test_asqMapping  - - - - - - - - - - - - - - - - - - - - - - - - - -


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

if '__main__' == __name__ :
    unittest.main()

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -