#!/usr/bin/env python

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
asqTypes (basic) test suite
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.5 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

import  os
import  unittest

import  py_netasq.commonlib.asqFile                     as asqFile

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


class test_asqTypes(unittest.TestCase) :

    def testProtos1(self) :
        """\
          check if missing parameters or invalid types do raise exceptions.
        """
        self.assertRaises(TypeError, asqFile.fsize)
        self.assertRaises(TypeError, asqFile.fsize, None)
        self.assertRaises(TypeError, asqFile.fsize, 0)

        self.assertRaises(TypeError, asqFile.lastlines)
        self.assertRaises(TypeError, asqFile.lastlines, None)
        self.assertRaises(TypeError, asqFile.lastlines, None, 0)
        
        handle = file('dummy_file.txt', 'rU')
        try :
          self.assertRaises(TypeError, asqFile.lastlines, handle, None)
          self.assertRaises(ValueError, asqFile.lastlines, handle, -1)
        finally :
          handle.close()


    def testProtos2(self) :
        """\
          check if missing parameters or invalid types do raise exceptions.
        """
        self.assertRaises(TypeError, asqFile.readFile)
        self.assertRaises(TypeError, asqFile.readFile, None)
        self.assertRaises(TypeError, asqFile.readFile, r'dummy_file.txt', None)
        self.assertRaises(TypeError, asqFile.readFile, r'dummy_file.txt', 0, None)
        self.assertRaises(TypeError, asqFile.readFile, r'dummy_file.txt', 0, -1, None)
        
        self.assertRaises(TypeError, asqFile.writeFile)
        self.assertRaises(TypeError, asqFile.writeFile, None)
        self.assertRaises(TypeError, asqFile.writeFile, r'dummy_file.txt', None)
        self.assertRaises(TypeError, asqFile.writeFile, r'dummy_file.txt', '', None)
        self.assertRaises(TypeError, asqFile.writeFile, r'dummy_file.txt', '', 0, None)


    def testFsize1(self) :
        """\
          check fsize() results.
        """
        handle = file('dummy_file.txt', 'rU')
        f_stat = os.stat('dummy_file.txt')
        try :
          buffer = asqFile.fsize(handle)
          self.assertEqual(f_stat.st_size , buffer)
        finally :
          handle.close()
        
        handle = file('test_asqFile.py', 'rU')
        f_stat = os.stat('test_asqFile.py')
        try :
          buffer = asqFile.fsize(handle)
          self.assertEqual(f_stat.st_size , buffer)
        finally :
          handle.close()


    def testLastLines1(self) :
        """\
          check lastlines() results.
        """
        handle = file('test_asqFile.py', 'rU')
        try :
          # note : there is no carriage return before end of file
          expect = [
            '# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -\n',
            '# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
          ]
          buffer = asqFile.lastlines(handle, 2)
          self.assertEqual(expect, buffer)

          expect = [
            '# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -\n',
            '# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
          ]
          buffer = asqFile.lastlines(handle, 2)
          self.assertEqual(expect, buffer)

          expect = [
            '# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -\n',
            '\n',
            'if \'__main__\' == __name__ :\n',
            '    unittest.main()\n',
            '\n',
            '# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -\n',
            '# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
          ]
          buffer = asqFile.lastlines(handle, 7)
          self.assertEqual(expect, buffer)

        finally :
          handle.close()


    def testSuite1(self) :
        """\
          check readFile() and writeFile()
        """
        backup = asqFile.readFile(r'dummy_file.txt', 0, -1, asqFile.SEEK_SET)
        f_stat = os.stat('dummy_file.txt')
        self.assertEqual(f_stat.st_size , len(backup))
        
        expect = "it can' be love, for there is no true love"+"\n"
        asqFile.writeFile(r'dummy_file.txt', expect, 0, asqFile.SEEK_SET)
        buffer = asqFile.readFile(r'dummy_file.txt', 0, -1, asqFile.SEEK_SET)
        self.assertEqual(expect, buffer)
        
        asqFile.writeFile(r'dummy_file.txt', backup, 0, asqFile.SEEK_SET)
        buffer = asqFile.readFile(r'dummy_file.txt', 0, -1, asqFile.SEEK_SET)
        self.assertEqual(backup, buffer)


  # /class test_asqTypes  - - - - - - - - - - - - - - - - - - - - - - - - - - -


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

if '__main__' == __name__ :
    unittest.main()

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -