#!/usr/bin/env python

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
asqDebug test case
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.5 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

import  sys
import  unittest

import  py_netasq.commonlib.asqDebug                    as asqDebug

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


class test_asqDebug(unittest.TestCase) :


    def testProtos1(self) :
        """\
          check if missing parameters or invalid types do raise exceptions.
        """
        self.assertRaises(TypeError, asqDebug.debugValue)
        self.assertRaises(TypeError, asqDebug.debugMessage)
        self.assertRaises(TypeError, asqDebug.varName)


    def testDebugValue1(self) :
        """\
          check if missing parameters or invalid types do raise exceptions.
        """
        self.assertRaises(TypeError, asqDebug.debugValue, 'a')
        self.assertRaises((AttributeError, TypeError), asqDebug.debugValue, 1, 'b')


    def testDebugMessage1(self) :
        """\
          check debugMessage() results.
        """
        self.assertEqual('', asqDebug.debugMessage(''))
        self.assertEqual('', asqDebug.debugMessage('', 4))
        self.assertEqual(' ', asqDebug.debugMessage(' '))
        self.assertEqual('   ', asqDebug.debugMessage(' ', 2))


    def testCalleeName1(self) :
        """\
          check calleeName() results.
        """
        self.assertEqual('testCalleeName1', asqDebug.calleeName())


    def testCallerName1(self) :
        """\
          check callerName() results.
        """
        self.assertEqual('__call__', asqDebug.callerName())


    def testVarName1(self) :
        """\
          check varName() result.
        """
        global a, b, c
        
        a = 44020
        self.assertEqual('a', asqDebug.varName(a, False))
        b = 44020
        self.assert_( asqDebug.varName(a, False) in ('a', 'b') )
        a = b * 9 + 4
        self.assert_('b' in asqDebug.varName(b, True))
        c = 4
        self.assert_('c' in asqDebug.varName(c, True))


    def testVarName2(self) :
        """\
          check varName() result.
        """
        self.assertEqual('classX', asqDebug.varName(classX, False))
        self.assert_(
            asqDebug.varName(objectX, False) in ('objectX', 'doubleX')
          )
        buffer = asqDebug.varName(objectX, True)
        self.assert_( isinstance(buffer, list) )
        buffer.sort()
        self.assertEqual(['doubleX', 'objectX'], buffer)


    def testVarName3(self) :
        """\
          check varName() result.
        """
        buffer = asqDebug.varName(sys.stdin, lookIn=('__main__', 'sys'))
        self.assert_(
            buffer in ('stdin', '__stdin__')
          )


    def testParameters1(self) :
        """\
          check parameters() results
        """
        self.assertEqual([]             , asqDebug.parameters())
        
        self.assertEqual([repr(True)]   , asqDebug.parameters(True))
        self.assertEqual([repr('True')] , asqDebug.parameters('True'))
        self.assertNotEqual([repr(True)], asqDebug.parameters('True'))
        
        self.assertEqual(['value='+ repr(True)] , asqDebug.parameters(value=True))
        self.assertEqual(['value='+ repr('True')] , asqDebug.parameters(value='True'))
        self.assertNotEqual(['value='+ repr('True')] , asqDebug.parameters(value=True))


    def testParameters2(self) :
        """\
          check parameters() results
        """
        self.assertEqual(
            [repr(True), 'value='+ repr(True)],
            asqDebug.parameters(True, value=True)
          )
        self.assertEqual(
            [repr('True'), 'value='+ repr('True')],
            asqDebug.parameters('True', value='True')
          )
        self.assertNotEqual(
            [repr(True), 'value='+ repr('True')],
            asqDebug.parameters('True', value='True')
          )



  # /class test_asqDebug  - - - - - - - - - - - - - - - - - - - - - - - - - - -


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# set up needed for "varName()" test
class classX :
  pass

objectX = classX()
doubleX = objectX

a = None
b = None
c = None


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

if '__main__' == __name__ :
    unittest.main()

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -