#!/usr/bin/env python

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
asqConvert (basic) test suite
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.2 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

import  unittest

import  py_netasq.commonlib.asqConvert                  as asqConvert

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


class test_asqConvert(unittest.TestCase) :

    def testProtos1(self) :
        """\
          check if missing parameters or invalid types do raise exceptions.
        """
        self.assertRaises(TypeError, asqConvert.byteToHuman)
        self.assertRaises(TypeError, asqConvert.humanToByte)
        self.assertRaises(TypeError, asqConvert.secondToHuman)
        self.assertRaises(TypeError, asqConvert.byteToHuman, 'a')
        self.assertRaises(TypeError, asqConvert.humanToByte, 125)
        self.assertRaises(TypeError, asqConvert.secondToHuman, 'x')


    def testByteToHuman1(self) :
        """\
          check byteToHuman() results.
        """
        self.assertEqual( '0', asqConvert.byteToHuman(0))
        self.assertEqual('-1', asqConvert.byteToHuman(-1))
        self.assertEqual( '1', asqConvert.byteToHuman(1))
        self.assertEqual( '1023', asqConvert.byteToHuman(1023))
        self.assertEqual('-1023', asqConvert.byteToHuman(-1023))
        self.assertEqual( '1K', asqConvert.byteToHuman(1024))
        self.assertEqual('-1K', asqConvert.byteToHuman(-1024))
        self.assertEqual('1023K', asqConvert.byteToHuman(1048575))
        self.assertEqual('1M', asqConvert.byteToHuman(1048576))


    def testHumanToByte(self) :
        """\
          check humanToByte() results.
        """
        self.assertEqual( 0, asqConvert.humanToByte('0'))
        self.assertEqual(-1, asqConvert.humanToByte('-1'))
        self.assertEqual( 1, asqConvert.humanToByte('1'))
        self.assertEqual( 1023, asqConvert.humanToByte('1023'))
        self.assertEqual(-1023, asqConvert.humanToByte('-1023'))
        self.assertEqual( 1024, asqConvert.humanToByte('1K'))
        self.assertEqual(-1024, asqConvert.humanToByte('-1K'))
        self.assertEqual(1023*1024, asqConvert.humanToByte('1023K'))
        self.assertEqual(1048576, asqConvert.humanToByte('1M'))


    def testSecondToHuman1(self) :
        """\
          check secondToHuman() results.
        """
        self.assertEqual('0.00 second'  , asqConvert.secondToHuman(0))
        self.assertEqual('3.50 seconds' , asqConvert.secondToHuman(3.5))
        self.assertEqual('13.50 seconds', asqConvert.secondToHuman(13.5))
        
        self.assertEqual('1 minute 3 seconds'   , asqConvert.secondToHuman(63.8))
        self.assertEqual('2 minutes 43 seconds' , asqConvert.secondToHuman(163.5))



  # /class test_asqConvert  - - - - - - - - - - - - - - - - - - - - - - - - - -
  

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

if '__main__' == __name__ :
    unittest.main()

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -