#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
(Little) Less common, but still useful, types utilities.

Require
  Python        2.2

Functions
  bool          asBoolean(var value [, tuple falseVals])
  int           asInteger(var value [, int radix [, int default]])

  bool          isNonEmptyInstance(var value, var classinfo)
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.8 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# string values considered as False boolean values
FALSE_VALUES = ('', 'None', 'False')


def asBoolean(value, falseVals=FALSE_VALUES) :
    """\
      bool asBoolean(var value, tuple falseVals)
      
      Tries to converts given "value" to a boolean; the extra 'falseVals'
      parameter is used for string convertion: Alas python built-in type
      conversion only considers empty string as False values, any other
      string will be converted to True.
      e.g.
        bool('None')   => True
        bool('False')  => True
      
      'asBoolean' is intended to fix that nasty behavior, if given string
      is found in 'falseVals' (case insensitive search), then False is
      returned.
      e.g. FALSE_VALUES = ('', 'None', 'False')
           asBoolean('None', FALSE_VALUES)   => False
           asBoolean('False', FALSE_VALUES)  => False
      
      If value is not a string, then the built-in type convertion is used.
      
      param value                 string to convert
      param falseVals             False strings, defaults
                                    to asqTypes.FALSE_VALUES
      return                      boolean value
    """
    if not isinstance(falseVals, (list, tuple)) :
      raise TypeError("type mismatch `falseVals` parameter, expecting sequence")
    
    if not isinstance(value, basestring) :
      return bool(value)
    else :
      buffer = [x.lower() for x in falseVals]
      return value.strip().lower() not in buffer


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

def asInteger(value, radix=10, default=0) :
    """\
      int asInteger(var value, int radix, int default)
      
      Tries to converts given "value" to a plain integer. The "radix"
      parameter gives the base for the conversion and may be any integer in
      the range [2, 36], or zero. If "radix" is zero, the proper radix is
      guessed based on the contents of string; the interpretation is the
      same as for integer literals.
      If conversion fails, then the default value is returned instead.
      
      param value                 value to convert
      param radix                 conversion base
                                    defaults to 10 (decimal)
      param default               default convertion value
                                    defaults to 0
      return                      conversion result
    """
    if not isinstance(default, int) :
      raise TypeError("The 'default' parameter must be a valid integer value")
    elif isinstance(value, int) :
      return value
    try :
      return int(str(value), radix)
    except ValueError, e :
      return default


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

def isNonEmptyInstance(value, classinfo) :
    """\
      bool isNonEmptyInstance(var value, var classinfo)
      
      Returns whether or not the given "value" is a non empty
      'classinfo' instance.
      
      param value                 value to test
      param classinfo             class type to check
      return                      is value a non empty instance
    """
    return isinstance(value, classinfo) and bool(value)


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

if '__main__' == __name__ :
  print __file__
  print __doc__


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -