#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
(Little) Less common, but still useful, file manipulation functions.

Require
  Python        2.2

Constants
  int           SEEK_SET
  int           SEEK_REL
  int           SEEK_END

Functions
  long          fsize(object handle)
  list          lastlines(object handle, int count)
  string        readFile(string path, int offset, int length, int whence)
  void          writeFile(string path, string content, int offset, int whence)
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.0 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

#~ import  os

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# absolute file positioning
SEEK_SET = 0
# seek relative to the current position
SEEK_REL = 1
# seek relative to the file's end
SEEK_END = 2

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

def fsize(handle) :
    """\
      long fsize(object handle)
      
      Returns the size of the opened file. This is a dumb function : the
      file's position is set to the end of the file, then 'tell()' is used.
      
      It may not work for non seekable object file.
      
      param handle                file object
      return                      file size
    """
    if not isinstance(handle, file) :
      raise TypeError('fisze() argument must be a file handle')
    
    offset = handle.tell()
    try :
      handle.seek(0, SEEK_END)
      return handle.tell()
    finally :
      handle.seek(offset, SEEK_SET)


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

def lastlines(handle, count) :
    """\
      list lastlines(object handle, int count)
      
      Reads the 'count' last lines from the object file, like 'readlines()'.
      Be aware that end of line sequences will be present in the resulting
      list.
      
      It may not work for non seekable object file.
      
      param handle                file object
      param count                 number of lines to get
      return                      last lines, as a list
    """
    if not isinstance(handle, file) :
      raise TypeError('lastlines() argument must be a file handle')
    if not isinstance(count, int) :
      raise TypeError('lastlines() argument must be an integer')
    if 0 > count :
      raise ValueError('lastlines() psitive value expected')
    
    if 0 == count :
      return []
    
    result = None
    offset = 2048
    f_size = 0
    backup = handle.tell()
    
    try :
      f_size = fsize(handle)
      handle.seek(-offset, SEEK_END)
      result = handle.readlines()
      
      # avoid infinite loop if file has less than 'count' lines
      while (f_size > offset) and (count > len(result)) :
        # offset = 2 * offset
        offset = offset << 1
        handle.seek(-offset, SEEK_END)
        result = handle.readlines()
      
      return result[-count:]
      
    finally :
      # whence=0 => absolute file positioning
      handle.seek(backup, SEEK_SET)


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

def readFile(path, offset=0, length=-1, whence=SEEK_SET) :
    """\
      string readFile(string path, int offset, int length, int whence)
      
      Returns a file's content as a string.
      This function first sets up the file position indicator, according
       to 'offset' and 'whence' values, for the file referenced by 'path'.
       Then, up to 'length' bytes are read, and returned as result, from
       the opened file descriptor.
      Reading stops when up to 'length' bytes have been read, or if EOF
       (end of file) is reached.
      
      The 'whence' and 'offset' parameters have exactly the same meaning
       than for the file object "seek()" function.
      
      Note : To move to a position before the end-of-file, you need to set
       'whence' to SEEK_END, and pass a _negative_ value as offset.
      
      param path                  source absolute file path
      param offset                starting position; defaults to 0
      param length                how many bytes should be read;
                                    defaults to -1
      param whence                seeking mode; defaults to asqFile.SEEK_SET
      return                      file content
    """
    if not isinstance(path, basestring) :
      raise TypeError('readFile() argument must be a path string')
    if not isinstance(offset, int) :
      raise TypeError('readFile() argument must be an integer')
    if not isinstance(length, int) :
      raise TypeError('readFile() argument must be an integer')
    if not isinstance(whence, int) :
      raise TypeError('readFile() argument must be an integer')
    
    if 0 == length :
      return ''
    
    handle = open(path, 'rbU')
    try :
      handle.seek(offset, whence)
      if -1 < length :
        return handle.read(length)
      else :
        return handle.read()
      
    finally :
      handle.close()


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

def writeFile(path, content, offset=0, whence=SEEK_SET) :
    """\
      void writeFile(string path, string content, int offset, int whence)
      
      Write a string to a file, at specified offset.
      The string will overwrite any previous content; The file length may
       be modified so that the end of file is right after the new content.
      
      The 'whence' and 'offset' parameters have exactly the same meaning
       than for the file object "seek()" function.
      
      Note : To move to a position before the end-of-file, you need to set
       'whence' to SEEK_END, and pass a _negative_ value as offset.
      
      param path                  source absolute file path
      param content               string to write in file
      param offset                starting position; defaults to 0
      param whence                seeking mode; defaults to asqFile.SEEK_SET
    """
    if not isinstance(path, basestring) :
      raise TypeError('writeFile() argument must be a path string')
    if not isinstance(content, basestring) :
      raise TypeError('writeFile() argument must be a string')
    if not isinstance(offset, int) :
      raise TypeError('writeFile() argument must be an integer')
    if not isinstance(whence, int) :
      raise TypeError('writeFile() argument must be an integer')
    
    handle = open(path, 'wb')
    try :
      handle.seek(offset, whence)
      # truncate() : the size defaults to the current position
      handle.truncate()
      handle.write(content)
      
    finally :
      handle.close()


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

if '__main__' == __name__ :
  print __file__
  print __doc__


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -