#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
(Little) Less common, but still useful, unit (not type) convertion utilities.

Require
  Python        2.2

Functions
  string        byteToHuman(int value)
  int           humanToByte(string value)
  
  string        secondToHuman(float value)
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.4 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

import  math

#~ from    py_netasq.commonlib             import asqTypes

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

def byteToHuman(value) :
    """\
      string byteToHuman(int value)
      
      Converts given byte size "value" into a human readable string. Only
      the biggest unit is considered, e.g. 1 049 600 (1024 * 1024 + 1024)
      will be converted to "1M" (precision is indeed lost).
      
      Note : 1K = 1024 (2^10)
      
      param value                 value to convert
      return                      conversion result
    """
    if not isinstance(value, int) :
      raise TypeError("The 'value' parameter must be a valid integer value")
    
    if 0 == value :
      return '0'
    elif 0 < value :
      result = '%u%s'
    else :
      result = '-%u%s'
      value  = abs(value)
    
    buffer = value >> 30
    if 0 < buffer :
      return result % (buffer, 'G')
    buffer = value >> 20
    if 0 < buffer :
      return result % (buffer, 'M')
    buffer = value >> 10
    if 0 < buffer :
      return result % (buffer, 'K')
    
    # below 1024
    return result % (value, '')


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

def humanToByte(value) :
    """\
      int humanToByte(string value)
      
      Converts given human readable byte size string "value" into a integer
      value. If an empty string is provided, then -1 will be returned.
      
      Note : 1K = 1024 (2^10)
      
      param value                 value to convert
      return                      conversion result
    """
    if not isinstance(value, basestring) :
      raise TypeError("The 'value' parameter must be a valid string value")
    
    value  = value.strip()
    if 0 == len(value) :
      return 0
    
    buffer = value[-1:].upper()
    if   'G' == buffer :
      return int(value[:-1].strip(), 10) << 30
    elif 'M' == buffer :
      return int(value[:-1].strip(), 10) << 20
    elif 'K' == buffer :
      return int(value[:-1].strip(), 10) << 10
    else :
      return int(value, 10)


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

def secondToHuman(value) :
    """\
      string secondToHuman(float value)
      
      Converts given time interval "value", in seconds, into a human
      readable string (milli-second precision may be lost).
      
      param value                 value to convert
      return                      conversion result
    """
    if not isinstance(value, (float, int)) :
      raise TypeError("The 'value' parameter must be a valid integer value")
    
    value  = max(0, value)
    result = ''
    
    if 0 <= value <= 1 :
      result = '%2.2f second'  % (value, )
    elif 1 < value < 60 :
      result = '%2.2f seconds' % (value, )
    else :
      chunks = list()
    
      # seconds to hours
      buffer = divmod(value, 3600)
      if 0 == buffer[0] :
        pass
      elif 2 > buffer[0] :
        chunks.append('%u hour'  % (buffer[0], ))
      else :
        chunks.append('%u hours' % (buffer[0], ))
      
      # seconds to minutes
      buffer = divmod(buffer[1], 60)
      if 0 == buffer[0] :
        pass
      elif 2 > buffer[0] :
        chunks.append('%u minute'  % (buffer[0], ))
      else :
        chunks.append('%u minutes' % (buffer[0], ))
    
      if 0 == buffer[1] :
        pass
      elif 2 > buffer[1] :
        chunks.append('%u second'  % (buffer[1], ))
      else :
        chunks.append('%u seconds' % (buffer[1], ))
      
      #~ # extract the floating part
      #~ buffer = buffer[1] - math.floor(buffer[1])
      #~ buffer = round(1000 * buffer)
      #~ if 0 == buffer :
        #~ pass
      #~ else :
        #~ chunks.append('%u ms'  % (buffer, ))
      
      result = ' '.join(chunks)
    
    return result


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

if '__main__' == __name__ :
  print __file__
  print __doc__


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -