#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
Deprecated - use the asqCommand unit instead.
A simple command line building class, provide methods to surround arguments
with quotes and ease ;).

Require
  Python        2.3
  
Classes
  class         asqCmdLine(void) extends list
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.5 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

import  py_netasq.commonlib.asqString           as asqString

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

class asqCmdLine(list) :
    """\
      A simple class to ease command line building. The command is handled
      as a simple list : the first item is the command's exe, others are
      command's args (or at least it should be).
      
      This class implements the __str__ function.
      Beware: this is a new-style class (derivated from 'list')
      
      
      void appendQuoted(string s)
      void insertQuoted(int i, string s)
      void removeQuoted(string s)
      
      void clear(void)
    """

  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # Constructor - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # Special methods - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def __str__(self) :
        """\
          string __str__(void)
          
          Called by the 'str()' built-in function and by the 'print' statement
          to compute the "informal" string representation of an object. This
          differs from __repr__() in that it does not have to be a valid
          Python expression: a more convenient or concise representation may
          be used instead. The return value must be a string object.
          
          Return full command line, ready to be used.
          
          return                      string representation
        """
        return ' '.join(self[:])


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def appendQuoted(self, s) :
        """\
          void appendQuoted(string s)
          
          Append given string 's' to command's chunks (self.items), double
          quotes are added on each sides of the string.
          
          param s                     string to append
        """
        self.append(asqString.quoteString(s, '"', '\\'))


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def insertQuoted(self, i, s) :
        """\
          void insertQuoted(int i, string s)
          
          Insert given string 's' at given position 'i' to command's chunks;
          double quotes are added on each sides of the string.
          
          param i                     string index in list
          param s                     string to append
        """
        self.insert(i, asqString.quoteString(s, '"', '\\'))


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def removeQuoted(self, s) :
        """\
          void removeQuoted(string s)
          
          Removes the first string that matches the quoted version of 's'.
          
          param s                     string to remove
        """
        self.remove(asqString.quoteString(s, '"', '\\'))


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def clear(self) :
        """\
          void clear(void)
          
          Empty command line items
        """
        self[:] = []


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # class asqCmdLine  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

if '__main__' == __name__ :
  print __file__
  print __doc__


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -