#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
A delphi building utility: Wrapper around versioning app (resModifier).

Require
  Python        2.3

Classes
  class         vrsTaskHandler(object aTask, object logger)
                  extends py_netasq.building.core::taskHandler
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.8 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

from    py_netasq               import building as asqBuild
from    py_netasq.building      import core     as asqBuildCore

import  tasks


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

class vrsTaskHandler(asqBuildCore.taskHandler) :
    """\
      Wrapper around *.res modifier app. Settings have to be set through
      object's "task" (class vrsTaskItem) attribute.
    """

    # task class
    taskClass = tasks.vrsTaskItem

  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def _setup(self, *arglist, **argdict) :
        """\
          void _setup(void)
          
          Called right before the actual command execution; should be
          overidden to set up the execution environment.
          
          - Create (and fill) a temporary unattended build file
          
          param *arglist              extra parameters.
          param **argdict             extra named parameters.
        """
        asqBuild.logger.trace('vrsTaskHandler._setup()')
        asqBuild.logger.incDepthTrace()
        try :
          
          super(vrsTaskHandler, self)._setup(*arglist, **argdict)
          self._createTmpFile('.ver')
          self._task.buildTmpFile(self._tmpFile)
          
          #~ print '//vrsTaskHandler._setup'
          #~ buffer = open(self._task.tmpfile, 'r')
          #~ try :
            #~ print ''.join( buffer.readlines() )
          #~ finally :
            #~ buffer.close
          
        finally :
          asqBuild.logger.decDepthTrace()


    def _teardown(self, *arglist, **argdict) :
        """\
          void _teardown(void)
          
          Called right after the actual command execution; should be
          overidden to clean up the execution environment.
          
          - delete temporary unattended build file
          
          param *arglist              extra parameters.
          param **argdict             extra named parameters.
        """
        asqBuild.logger.trace('vrsTaskHandler._teardown()')
        asqBuild.logger.incDepthTrace()
        try :
          
          self._deleteTmpFile()
          super(vrsTaskHandler, self)._teardown(*arglist, **argdict)
         
        finally :
          asqBuild.logger.decDepthTrace()


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def _execute(self, cmdStr, raw, *arglist, **argdict) :
        """\
          var _execute(string cmdStr, bool raw, *arglist, **argdict)
          
          Execute inner command line and return the shell status.
          Each line from stdout and stderr will be decoded and processed,
          i.e. lines will go through _decodeOutput() and _processOutput().
          
          param cmdStr                command as a string to execute.
          param raw                   disable output formatting
          param *arglist              extra parameters list.
          param **argdict             extra named parameters.
          return                      shell status
        """
        # trash given command string 'cmdStr', a more accurate one
        # has to be generated, with included tmpfile path.
        buffer = str(self._task.toCmdLine()).strip()
        
        if 0 == len(buffer) :
          return None
        else :
          return super(vrsTaskHandler, self)._execute(buffer, raw, *arglist, **argdict)


  # Getters - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # Setters - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # Properties  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # /class vrsTaskHandler - - - - - - - - - - - - - - - - - - - - - - - - - - -


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

if '__main__' == __name__ :
  print __file__
  print __doc__


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -