#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
A delphi building utility: Wrapper around svn client.

Require
  Python        2.2

Classes
  class         svnTaskHandler(object aTask, object logger)
                  extends py_netasq.building.core::taskHandler
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.1 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

import  os

from    py_netasq.commonlib     import asqPath

from    py_netasq               import building as asqBuild
from    py_netasq.building      import core     as asqBuildCore

import  tasks


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

class svnTaskHandler(asqBuildCore.taskHandler) :
    """\
      Wrapper around svn client. Settings have to be set through
      object's "task" (class svnTaskItem) attribute.
    """

    # task class
    taskClass   = tasks.svnTaskItem

  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    #~ def __init__(self, aTask=None) :
        #~ """\
          #~ constructor taskHandler(object aTask)
          
          #~ Create a new object intended to ease command line execution.
          
          #~ param aTask                 task to execute.
                                       #~ defaults to None
        #~ """
        #~ super(svnTaskHandler, self).__init__(aTask)
        #~ self._initRsh = None


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    #~ def debug(self) :
        #~ """\
          #~ void debug(void)
          
          #~ Prints out the main attributes values through the logging
          #~ utility.
        #~ """
        #~ self._debugKeyVal('CVS_RSH', os.getenv(self.ENV_CVS_RSH, None))
        #~ self._debugKeyVal('_initRsh', self._initRsh)
        #~ super(svnTaskHandler, self).debug()


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    #~ def _setup(self, *arglist, **argdict) :
        #~ """\
          #~ void _setup(*arglist, **argdict)
          
          #~ Called right before the actual command execution; should be
          #~ overidden to set up the execution environment.
          
          #~ - Some svn command ('update') has to be executed from within
           #~ the destination directory, so we switch the current directory;
           #~ If detination dir does not exist, it will be created, but an
           #~ exception may be raised if directory creation is impossible
           #~ (ex for MS windows: give a wrong drive letter).
          #~ - CVS_RSH Environnement value has to be properly set.
          
          #~ param *arglist              extra parameters.
          #~ param **argdict             extra named parameters.
        #~ """
        #~ asqBuild.logger.trace('svnTaskHandler._setup()')
        #~ asqBuild.logger.incDepthTrace()
        #~ try :
          
          #~ super(svnTaskHandler, self)._setup(*arglist, **argdict)
          #~ self._pushCwd(self._task.destdir)
          
          #~ if self._task.cvsrsh is None :
            #~ self._initRsh = None
          #~ else :
            #~ self._initRsh = os.getenv(self.ENV_CVS_RSH, None)
            #~ os.putenv(self.ENV_CVS_RSH, self._task.cvsrsh)
         
        #~ finally :
          #~ asqBuild.logger.decDepthTrace()


    #~ def _teardown(self, *arglist, **argdict) :
        #~ """\
          #~ void _teardown(*arglist, **argdict)
          
          #~ Called right after the actual command execution; should be
          #~ overidden to clean up the execution environment.
          
          #~ - switch back directory
          #~ - restore previous CVS_RSH value
          
          #~ param *arglist              extra parameters.
          #~ param **argdict             extra named parameters.
        #~ """
        #~ asqBuild.logger.trace('svnTaskHandler._teardown()')
        #~ asqBuild.logger.incDepthTrace()
        #~ try :
          
          #~ self._popCwd()
          #~ if self._initRsh is not None :
            #~ os.putenv(self.ENV_CVS_RSH, self._initRsh)
          #~ super(svnTaskHandler, self)._teardown(*arglist, **argdict)
         
        #~ finally :
          #~ asqBuild.logger.decDepthTrace()


  # Getters - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # Setters - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # Properties  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # /class svnTaskHandler - - - - - - - - - - - - - - - - - - - - - - - - - - -


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

if '__main__' == __name__ :
  print __file__
  print __doc__


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -