#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.1 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

import  logging
import  os

import  py_netasq.commonlib.asqDebug            as asqDebug
import  py_netasq.commonlib.asqLogging          as asqLogging
import  py_netasq.commonlib.asqPath             as asqPath
import  py_netasq.commonlib.asqRepr             as asqRepr

import  py_netasq.building                      as asqBuild
import  py_netasq.building.core                 as asqBuildCore
import  py_netasq.building.tasks                as asqBuildTasks


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

DBG_LOGGER = asqBuild.logger
DBG_LOGLVL = logging.INFO

# globally disable TRACE logging message
asqBuild.logger.excludeLvl.append(asqLogging.TRACE)

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

aTaskListDebug = asqDebug.objectDebug(asqBuildTasks.svnTaskList, 'aTaskListDebug')
aTaskListDebug.logger           = DBG_LOGGER
aTaskListDebug.logLevel         = DBG_LOGLVL

aTaskItemDebug = asqDebug.objectDebug(asqBuildTasks.svnTaskItem, 'aTaskItemDebug')
aTaskItemDebug.logger           = DBG_LOGGER
aTaskItemDebug.logLevel         = DBG_LOGLVL

aTaskHandlerDebug = asqDebug.objectDebug(asqBuildTasks.svnTaskHandler, 'aTaskHandlerDebug')
aTaskHandlerDebug.logger        = DBG_LOGGER
aTaskHandlerDebug.logLevel      = DBG_LOGLVL

asqRepr.aRepr.logger            = DBG_LOGGER
asqRepr.aRepr.logLevel          = logging.DEBUG
asqRepr.aRepr.maxstring         = 40
asqRepr.aRepr.maxlist           = 15


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# temp subversion repository
SVN_REPOSITORY = r'https://labo.netasq.com/svn/NETASQ/convert'

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# accurate task settings
list_settings = {
    'workdir'   : '.',
    'destdir'   : r'.\dummy',
    'client'    : r'C:\Program Files\Subversion\bin\svn.exe',
    'command'   : 'checkout',
  }

# dummy task settings
list_dummy    = {
    'url'       : 'wrong value',
    'url2'      : 'kllrk',
    'zobi'      : 'biroutte',
  }


# accurate task settings
item_settings = {
    'enabled'   : True,
    'url0'      : SVN_REPOSITORY +'/project/delphi/globaladmin/globaladmin',
  }

# dummy task settings
item_dummy     = {
  }


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

print ''

#~ aTaskListDebug.classAttributes()
#~ print ''
#~ aTaskListDebug.objectInit(enabled=False)
#~ aTaskListDebug.objectDel()

#~ print ''
#~ print '# - - - - - - - - - - - - - - - - - - -'
#~ print ''


aTaskListDebug.objectInit(enabled=True)

#~ print ''
#~ aTaskListDebug.objectCallFunc('debug')

print ''
aTaskListDebug.objectBatchSetAttr(list_settings)
aTaskListDebug.objectBatchSetAttr(list_dummy)

#~ print ''
#~ aTaskListDebug.objectCallFunc('debug')

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# check that values stand where they are expected to be
for (key, val) in list_settings.iteritems() :
  buffer = aTaskListDebug.objectGetAttr(key)
  assert val == buffer  , "attribute `%s` - got %s expected %s" % (key, repr(buffer), repr(val))

# check others dictionnary
buffer = aTaskListDebug.objectGetAttr('others')
assert isinstance(buffer, dict), "task.others : dictionnary expected"
buffer = buffer.keys()
for key in list_dummy.iterkeys() :
  assert key in buffer, "`%s` missing from the 'others' dictionnary." % (key, )

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

print ''
buffer = aTaskListDebug.objectCallFunc('check')
buffer.debug()

print ''
print '# - - - - - - - - - - - - - - - - - - -'
print ''

aTaskItemDebug.objectInit(enabled=False)
aTaskItemDebug.objectBatchSetAttr(item_settings)

#~ print ''
#~ aTaskItemDebug.objectCallFunc('debug')

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# check that values stand where they are expected to be
for (key, val) in item_settings.iteritems() :
  buffer = aTaskItemDebug.objectGetAttr(key)
  assert val == buffer  , "attribute `%s` - got %s expected %s" % (key, repr(buffer), repr(val))

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

print ''
print '# - - - - - - - - - - - - - - - - - - -'
print ''

buffer = aTaskItemDebug.objectCallFunc('check')
buffer.debug()

print ''
print '# - - - - - - - - - - - - - - - - - - -'
print ''


aTaskListDebug.objectCallFunc('append', aTaskItemDebug.object)
#~ print ''
#~ buffer = aTaskListDebug.objectCallFunc('check')
#~ buffer.debug()


aTaskItemDebug.objectCallFunc('mergeWithTask', aTaskListDebug.object)
aTaskItemDebug.objectCallFunc('completePaths', None)

#~ print ''
#~ aTaskItemDebug.objectCallFunc('debug')

print ''
buffer = aTaskItemDebug.objectCallFunc('check')
buffer.debug()

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

print ''
print '# - - - - - - - - - - - - - - - - - - -'
print ''

aTaskHandlerDebug.objectInit(aTask=aTaskItemDebug.object)

buffer = aTaskHandlerDebug.objectCallFunc('task.check')
buffer.debug()

print ''
workdir = os.getcwd()


buffer = aTaskHandlerDebug.objectCallFunc('run')
asqRepr.representation(buffer)

#~ buffer = aTaskHandlerDebug.objectGetAttr('output')
#~ asqRepr.representation(buffer)


assert os.getcwd() == workdir, "failed to restore previous work directory"

# cleanup the mess
if aTaskItemDebug.objectGetAttr('destdir') is None :
  pass
elif os.path.exists(aTaskItemDebug.object.destdir) :
  asqPath.delete(aTaskItemDebug.object.destdir, True)


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -