#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.1 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

import  logging
import  os

from    py_netasq.commonlib     import asqDebug, asqLogging
from    py_netasq.commonlib     import asqPath, asqRepr

from    py_netasq               import building as asqBuild
from    py_netasq.building      import core     as asqBuildCore
from    py_netasq.building      import tasks    as asqBuildTasks


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

DBG_LOGGER = asqBuild.logger
DBG_LOGLVL = logging.INFO

# globally disable TRACE logging message
asqBuild.logger.excludeLvl.append(asqLogging.TRACE)

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

aTaskItemDebug = asqDebug.objectDebug(asqBuildTasks.svnTaskItem, 'aTaskItemDebug')
aTaskItemDebug.logger           = DBG_LOGGER
aTaskItemDebug.logLevel         = DBG_LOGLVL

aTaskHandlerDebug = asqDebug.objectDebug(asqBuildTasks.svnTaskHandler, 'aTaskHandlerDebug')
aTaskHandlerDebug.logger        = DBG_LOGGER
aTaskHandlerDebug.logLevel      = DBG_LOGLVL

asqRepr.aRepr.logger            = DBG_LOGGER
asqRepr.aRepr.logLevel          = logging.DEBUG
asqRepr.aRepr.maxstring         = 40
asqRepr.aRepr.maxlist           = 15


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# temp subversion repository
SVN_REPOSITORY = 'https://labo.netasq.com/svn/NETASQ/convert'

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# accurate task settings
item_settings = {
    'workdir'   : '.',
    'destdir'   : r'.\dummy',
    'client'    : r'C:\Program Files\Subversion\bin\svn.exe',
    'command'   : 'checkout',
    'url'       : SVN_REPOSITORY +'/project/delphi/globaladmin/globaladmin',
  }

# dummy task settings
item_dummy     = {
  }


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


print ''

#~ aTaskItemDebug.classAttributes()
#~ print ''
#~ aTaskItemDebug.objectInit(enabled=False)
#~ aTaskItemDebug.objectDel()

#~ print ''
#~ print '# - - - - - - - - - - - - - - - - - - -'
#~ print ''


aTaskItemDebug.objectInit(enabled=True)

#~ print ''
#~ aTaskItemDebug.objectCallFunc('debug')

print ''
aTaskItemDebug.objectBatchSetAttr(item_settings)
aTaskItemDebug.objectBatchSetAttr(item_dummy)

#~ print ''
#~ aTaskListDebug.objectCallFunc('debug')

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# check that values stand where they are expected to be
for (key, val) in item_settings.iteritems() :
  buffer = aTaskItemDebug.objectGetAttr(key)
  assert val == buffer  , "attribute `%s` - got %s expected %s" % (key, repr(buffer), repr(val))

# check others dictionnary
buffer = aTaskItemDebug.objectGetAttr('others')
assert isinstance(buffer, dict), "task.others : dictionnary expected"
buffer = buffer.keys()
for key in item_dummy.iterkeys() :
  assert key in buffer, "`%s` missing from the 'others' dictionnary." % (key, )

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

#~ print ''
#~ aTaskItemDebug.objectCallFunc('debug')

aTaskItemDebug.objectCallFunc('completePaths', baseDir=None)

#~ print ''
#~ aTaskItemDebug.objectCallFunc('debug')

print ''
buffer = aTaskItemDebug.objectCallFunc('check')
buffer.report(DBG_LOGGER)

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

print ''
print '# - - - - - - - - - - - - - - - - - - -'

#~ print ''
#~ aTaskHandlerDebug.classAttributes()


print ''
aTaskHandlerDebug.objectInit(aTask=None)
aTaskHandlerDebug.objectDel()
aTaskHandlerDebug.objectInit(aTask=aTaskItemDebug.object)

print ''
buffer = aTaskHandlerDebug.objectCallFunc('task.check')
buffer.report(DBG_LOGGER)

#~ print ''
#~ aTaskHandlerDebug.objectCallFunc('task.debug')

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

print ''
print '# - - - - - - - - - - - - - - - - - - -'

print ''
buffer = aTaskHandlerDebug.objectCallFunc('task.antDisplay')
DBG_LOGGER.debug(buffer)


workdir = os.getcwd()


#~ print ''
#~ buffer = aTaskHandlerDebug.objectCallFunc('run')
#~ asqRepr.representation(buffer)

#~ buffer = aTaskHandlerDebug.objectGetAttr('output')
#~ asqRepr.representation(buffer)


assert os.getcwd() == workdir, "failed to restore previous work directory"

# cleanup the mess
if aTaskItemDebug.objectGetAttr('destdir') is None :
  pass
elif os.path.exists(aTaskItemDebug.object.destdir) :
  asqPath.delete(aTaskItemDebug.object.destdir, True)


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# accurate task settings
item_settings = {
    'workdir'   : '.',
    'destdir'   : r'.\dummy',
    'client'    : r'C:\Program Files\Subversion\bin\svn.exe',
    'command'   : 'checkout',
    'url0'      : SVN_REPOSITORY +'/project/delphi/globaladmin/globaladmin',
    'url1'      : SVN_REPOSITORY +'/project/delphi/globaladmin/globaladmininterface',
    'url2'      : SVN_REPOSITORY +'/project/delphi/globaladmin/globalupdate',
  }

# dummy task settings
item_dummy     = {
  }


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

print ''
print '# - - - - - - - - - - - - - - - - - - -'
print ''


aTaskItemDebug.objectDel()
aTaskItemDebug.objectInit(enabled=True)

#~ print ''
#~ aTaskItemDebug.objectCallFunc('debug')

print ''
aTaskItemDebug.objectBatchSetAttr(item_settings)
aTaskItemDebug.objectBatchSetAttr(item_dummy)

#~ print ''
#~ aTaskListDebug.objectCallFunc('debug')

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# check that values stand where they are expected to be
for (key, val) in item_settings.iteritems() :
  buffer = aTaskItemDebug.objectGetAttr(key)
  assert val == buffer  , "attribute `%s` - got %s expected %s" % (key, repr(buffer), repr(val))

# check others dictionnary
buffer = aTaskItemDebug.objectGetAttr('others')
assert isinstance(buffer, dict), "task.others : dictionnary expected"
buffer = buffer.keys()
for key in item_dummy.iterkeys() :
  assert key in buffer, "`%s` missing from the 'others' dictionnary." % (key, )

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

#~ print ''
#~ aTaskItemDebug.objectCallFunc('debug')

aTaskItemDebug.objectCallFunc('completePaths', baseDir=None)

#~ print ''
#~ aTaskItemDebug.objectCallFunc('debug')

#~ print ''
#~ buffer = aTaskItemDebug.objectCallFunc('check')
#~ buffer.report(DBG_LOGGER)

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

print ''
print '# - - - - - - - - - - - - - - - - - - -'
print ''

aTaskHandlerDebug.objectInit(aTask=aTaskItemDebug.object)

#~ print ''
#~ buffer = aTaskHandlerDebug.objectCallFunc('task.check')
#~ buffer.report(DBG_LOGGER)

#~ print ''
#~ aTaskHandlerDebug.objectCallFunc('task.debug')

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

print ''
print '# - - - - - - - - - - - - - - - - - - -'

print ''
buffer = aTaskHandlerDebug.objectCallFunc('task.antDisplay')
DBG_LOGGER.debug(buffer)



workdir = os.getcwd()

print ''
buffer = aTaskHandlerDebug.objectCallFunc('run')
asqRepr.representation(buffer)

#~ buffer = aTaskHandlerDebug.objectGetAttr('output')
#~ asqRepr.representation(buffer)

assert os.getcwd() == workdir, "failed to restore previous work directory"

# cleanup the mess
if aTaskItemDebug.objectGetAttr('destdir') is None :
  pass
elif os.path.exists(aTaskItemDebug.object.destdir) :
  asqPath.delete(aTaskItemDebug.object.destdir, True)


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -