#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
A delphi building utility: Wrapper around Indigo Rose Setup Factory.

Require
  Python        2.3

Classes
  class         sf6TaskHandler(object aTask, object logger)
                  extends py_netasq.building.core::taskHandler
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.8 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

from    py_netasq               import building as asqBuild
from    py_netasq.building      import core     as asqBuildCore

import  tasks


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

class sf6TaskHandler(asqBuildCore.taskHandler) :
    """\
      Wrapper around Indigo Rose Setup Factory. Settings have to be set
      through object's "task" (class sf6TaskItem) attribute.
    """

    # task class
    taskClass = tasks.sf6TaskItem

  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def _setup(self, *arglist, **argdict) :
        """\
          void _setup(*arglist, **argdict)
          
          Called right before the actual command execution; should be
          overidden to set up the execution environment.
          
          - Create (and fill) a temporary unattended build file
          
          param *arglist              extra parameters.
          param **argdict             extra named parameters.
        """
        asqBuild.logger.trace('sf6TaskHandler._setup()')
        asqBuild.logger.incDepthTrace()
        try :
          
          super(sf6TaskHandler, self)._setup(*arglist, **argdict)
          self._createTmpFile('.ini')
          self._task.buildTmpFile(self._tmpFile)
          
          #~ print '//sf6TaskHandler._setup'
          #~ buffer = open(self._task.tmpfile, 'r')
          #~ try :
            #~ print ''.join( buffer.readlines() )
          #~ finally :
            #~ buffer.close
          
        finally :
          asqBuild.logger.decDepthTrace()


    def _teardown(self, *arglist, **argdict) :
        """\
          void _teardown(*arglist, **argdict)
          
          Called right after the actual command execution; should be
          overidden to clean up the execution environment.
          
          - delete temporary unattended build file
          
          param *arglist              extra parameters.
          param **argdict             extra named parameters.
        """
        asqBuild.logger.trace('sf6TaskHandler._teardown()')
        asqBuild.logger.incDepthTrace()
        try :
          
          self._deleteTmpFile()
          super(sf6TaskHandler, self)._teardown(*arglist, **argdict)
          
        finally :
          asqBuild.logger.decDepthTrace()


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def _execute(self, cmdStr, raw, *arglist, **argdict) :
        """\
          var _execute(string cmdStr, bool raw, *arglist, **argdict)
          
          Execute inner command line and return the shell status.
          Each line from stdout and stderr will be decoded and processed,
          i.e. lines will go through _decodeOutput() and _processOutput().
          
          param cmdStr                command as a string to execute.
          param raw                   disable output formatting
          param *arglist              extra parameters list.
          param **argdict             extra named parameters.
          return                      shell status
        """
        # trash given command string 'cmdStr', a more accurate one
        # has to be generated, with included tmpfile path.
        buffer = str(self._task.toCmdLine()).strip()
        
        if 0 == len(buffer) :
          return None
        else :
          return super(sf6TaskHandler, self)._execute(buffer, raw, *arglist, **argdict)


  # Getters - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # Setters - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # Properties  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # /class sf6TaskHandler - - - - - - - - - - - - - - - - - - - - - - - - - - -


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

if '__main__' == __name__ :
  print __file__
  print __doc__


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -