#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
A versatile custom task item used by the building utility.

Require
  Python        2.2

Constants
  string        rawTaskType

Classes
  class         rawTaskItem(bool enabled)
                  extends py_netasq.building.core::taskItem
  class         rawTaskList(bool enabled)
                  extends py_netasq.building.core::taskList
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.18 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

import  os
import  re

from    py_netasq.commonlib     import asqFile, asqSequence, asqPath
from    py_netasq.commonlib     import asqString, asqTypes, asqWin

from    py_netasq               import building as asqBuild
from    py_netasq.building      import core     as asqBuildCore


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

rawTaskType = 'rawTask'

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

BAT_TEMPLATE = r'bat_template.txt'

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

class rawTask(asqBuildCore.task) :
    """\
      A custom flexible task.
    """

    # class task type, nuff said :)
    classTaskType = rawTaskType

    # task type compatibility list
    compatibility = asqBuildCore.task.compatibility + (
        classTaskType,
      )

    # Properties defined for that task type and its descendant.
    # Note : attribute names should be "lower case" only.
    attributes    = (
        'taskname',             # task name (should held section name)
        'tasktype',             # task type as a string
        'enabled',              # is task active ?
        'workdir',              # task base directory
        'comments',             # about this task
        
        #~ 'arglist',              # dynamic arguments list
        'update_environ',       # update system env after task execution ?
        
        'tmpfile',              # command line wrapper
        'envfile',              # OS environment dump
        'others'                # unrecognized attributes
      )

    # recognize task arg names : argXX
    reArgItem     = re.compile(r'^arg(?P<argId>\d+)$', re.IGNORECASE)

  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    #~ def __getattr__(self, name) :
        #~ """\
          #~ var __getattr__(string name)
         
          #~ Special method - Called when an attribute lookup has not found
          #~ the attribute in the usual places (i.e. it is not an instance
          #~ attribute nor is it found in the class tree for self). name is
          #~ the attribute name. This method should return the (computed)
          #~ attribute value or raise an AttributeError exception.
          
          #~ Handles 'argXX' attributes, similary as __setattr__.
          
          #~ param name                  requested attribute
          #~ return                      attribute value
        #~ """
        #~ asqBuild.logger.trace('rawTask.__getattr__(%s)', name)
        #~ asqBuild.logger.incDepthTrace()
        #~ try :
          
          #~ # recognize argXX attributes
          #~ matchd = self.reArgItem.search(name)
          #~ if matchd is None :
            #~ super(rawTask, self).__getattr__(name)
          #~ else :
            #~ offset = int(matchd.group('argId'))
            #~ # may raise an "out of bound" exception
            #~ return self.arglist[offset]
          
        #~ finally :
          #~ asqBuild.logger.decDepthTrace()


    #~ def __setattr__(self, name, value) :
        #~ """\
          #~ void __setattr__(string name, var value)
          
          #~ Special method - Called when an attribute assignment is attempted.
          #~ This is called instead of the normal mechanism (i.e. store the
          #~ value in the instance dictionary). name is the attribute name,
          #~ value is the value to be assigned to it.
          
          #~ If name is not found in defined attributes list, and is not a
          #~ mangled name (_classname__name), then (name, value) is added to
          #~ the object's "others" dictionnary.
          
          #~ Each time an attribute value is set, 'normalize()' should be
          #~ called to ensure consistency.
          
          #~ param name                  attribute to set
          #~ param value                 new value
        #~ """
        #~ asqBuild.logger.trace('rawTask.__setattr__(%s, %s)', name, repr(value))
        #~ asqBuild.logger.incDepthTrace()
        #~ try :
          
          #~ if 'arglen' == name :
            #~ # pad self.arglist to at least match given length
            #~ buffer = asqTypes.asInteger(value, radix=0, default=0)
            #~ asqSequence.stuffSequence(self.arglist, buffer, None)
          #~ else :
            #~ # recognize argXX attributes
            #~ matchd = self.reArgItem.search(name)
            #~ if matchd is None :
              #~ super(rawTask, self).__setattr__(name, value)
            #~ else :
              #~ offset = int(matchd.group('argId'))
              #~ # ensure that offset is range 
              #~ asqSequence.stuffSequence(self.arglist, 1+offset, None)
              #~ self.arglist[offset] = value
          
        #~ finally :
          #~ asqBuild.logger.decDepthTrace()


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    #~ def _attributeNonZero(self, name) :
        #~ """\
          #~ bool _attributeNonZero(string name)
          
          #~ Callback used by self.__nonzero__()
          #~ Check that attribute is not empty.
          #~ Should be overriden to set the behavior for children classes.
          
          #~ param name                  attribute name
          #~ return                      is attribute NOT empty ?
        #~ """
        #~ if 'arglist' != name :
          #~ return super(rawTask, self)._attributeNonZero(name)
        #~ else :
          #~ return bool(self.arglist)


    #~ def _attributeDebug(self, name) :
        #~ """\
          #~ void _attributeDebug(string name)
          
          #~ Callback used by self.debug()
          #~ Prints out debug information for given attribute.
          #~ Should be overriden to set the behavior for children classes.
          
          #~ param name                  attribute name
        #~ """
        #~ if 'arglist' != name :
          #~ super(rawTask, self)._attributeDebug(name)
        #~ elif not self.arglist :
          #~ # empty arguments list
          #~ self._debugKeyVal(name, self.__dict__[name])
        #~ else :
          #~ asqBuild.logger.debug(name)
          #~ asqBuild.logger.incDepthDebug()
          #~ for i in xrange(len(self.arglist)) :
            #~ self._debugKeyVal('arg%d' % (i,), self.arglist[i])
          #~ asqBuild.logger.decDepthDebug()


    #~ def _attributeCheck(self, status, name) :
        #~ """\
          #~ void _attributeCheck(object status, string name)
          
          #~ Callback used by self.check(...)
          #~ Checks the value of attribute; Appends error or warning
          #~ messages to given check status.
          #~ Should be overriden to set the behavior for children classes.
          
          #~ param status                checkResult object
          #~ param name                  attribute name
        #~ """
        #~ if 'arglist' != name :
          #~ super(rawTask, self)._attributeCheck(status, name)
        #~ else :
          #~ buffer = filter(None, self.arglist)
          #~ if not buffer :
            #~ status.addMsgError('argList is empty')
          #~ elif not os.path.isabs(buffer[0]) :
            #~ # maybe a built-in shell command ?
            #~ pass
          #~ elif not os.path.isfile(buffer[0]) :
            #~ status.addMsgError('cannot find executable')


    #~ def _attributeToList(self, aList, name) :
        #~ """\
          #~ void _attributeToList(list aList, string name)
          
          #~ Callback used by self.toList(...)
          #~ Appends attribute to given "aList" list.
          #~ Should be overriden to set the behavior for children classes.
          
          #~ param aList                 list of attributes
          #~ param name                  attribute name
        #~ """
        #~ if 'arglist' != name :
          #~ super(rawTask, self)._attributeToList(aList, name)
        #~ else :
          #~ aList.append( ('arglen', self.arglen) )
          #~ for i in xrange(self.arglen) :
            #~ aList.append( ('arg%d' % (i,), self.arglist[i]) )


    #~ def _attributeReset(self, name) :
        #~ """\
          #~ void _attributeReset(string name)
          
          #~ Callback used by self.reset()
          #~ Resets attribute value.
          #~ Should be overriden to set the behavior for children classes.
          
          #~ param name                  attribute name
        #~ """
        #~ if 'arglist' != name :
          #~ super(rawTask, self)._attributeReset(name)
        #~ elif not hasattr(self, 'arglist') :
          #~ object.__setattr__(self, 'arglist', list())
        #~ else :
          #~ self.arglist[:] = []


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    #~ def isValid(self) :
        #~ """\
          #~ bool isValid(void)
          
          #~ Tells whether or not the task is "valid", id est, if mandatory
          #~ attributes are set; an empty task is not valid, but an invalid
          #~ task may not be empty ;)
          
          #~ return                      is task valid
        #~ """
        #~ asqBuild.logger.trace('rawTask.isValid()')
        #~ asqBuild.logger.incDepthTrace()
        #~ try :
          
          #~ if not super(rawTask, self).isValid() :
            #~ return False
          #~ else :
            #~ return bool(self.arglist)
          
        #~ finally :
          #~ asqBuild.logger.decDepthTrace()


  # Getters - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    #~ def _getArgLen(self) :
        #~ """\
          #~ int _getArgLen(void)
          
          #~ Getter - arglen property
        #~ """
        #~ return len(self.arglist)


  # Setters - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # Properties  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    #~ arglen    = property(
                  #~ doc  = "length of dynamic arguments list",
                  #~ fget = _getArgLen,
                  #~ fset = None,
                  #~ fdel = None )


  # /class rawTask  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


class rawTaskItem(rawTask, asqBuildCore.taskItem) :
    """\
      A custom flexible task.
      
      property int      arglen
    """
    
    ant_name    = 'raw'
    
    # Properties defined for that task type and its descendant.
    # Note : attribute names should be "lower case" only.
    attributes  = (
        'taskname',             # task name (should held section name)
        'tasktype',             # task type as a string
        'enabled',              # is task active ?
        'workdir',              # task base directory
        'comments',             # about this task
        
        'arglist',              # dynamic arguments list
        'update_environ',       # update system env after task execution ?
        
        'tmpfile',              # command line wrapper
        'envfile',              # OS environment dump
        'others'                # unrecognized attributes
      )

    # properties that could be overwritten by a "Merge" method
    mergeable   = (
        'workdir',
        'update_environ',
      )

 
  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def __getattr__(self, name) :
        """\
          var __getattr__(string name)
         
          Special method - Called when an attribute lookup has not found
          the attribute in the usual places (i.e. it is not an instance
          attribute nor is it found in the class tree for self). name is
          the attribute name. This method should return the (computed)
          attribute value or raise an AttributeError exception.
          
          Handles 'argXX' attributes, similary as __setattr__.
          
          param name                  requested attribute
          return                      attribute value
        """
        asqBuild.logger.trace('rawTaskItem.__getattr__(%s)', name)
        asqBuild.logger.incDepthTrace()
        try :
          
          # recognize argXX attributes
          matchd = self.reArgItem.search(name)
          if matchd is None :
            return object.__getattr__(self, name)
          else :
            offset = int(matchd.group('argId'))
            # may raise an "out of bound" exception
            return self.arglist[offset]
          
        finally :
          asqBuild.logger.decDepthTrace()


    def __setattr__(self, name, value) :
        """\
          void __setattr__(string name, var value)
          
          Special method - Called when an attribute assignment is attempted.
          This is called instead of the normal mechanism (i.e. store the
          value in the instance dictionary). name is the attribute name,
          value is the value to be assigned to it.
          
          If name is not found in defined attributes list, and is not a
          mangled name (_classname__name), then (name, value) is added to
          the object's "others" dictionnary.
          
          Each time an attribute value is set, 'normalize()' should be
          called to ensure consistency.
          
          param name                  attribute to set
          param value                 new value
        """
        asqBuild.logger.trace('rawTaskItem.__setattr__(%s, %s)', name, repr(value))
        asqBuild.logger.incDepthTrace()
        try :
          
          #~ # recognize argXX attributes
          #~ matchd = self.reArgItem.search(name)
          
          if 'arglen' == name :
            # pad self.arglist to at least match given length
            buffer = asqTypes.asInteger(value, radix=0, default=0)
            asqSequence.stuffSequence(self.arglist, buffer, None)
          else :
            # recognize argXX attributes
            matchd = self.reArgItem.search(name)
            if matchd is None :
              object.__setattr__(self, name, value)
            else :
              offset = int(matchd.group('argId'))
              # ensure that offset is range 
              asqSequence.stuffSequence(self.arglist, 1+offset, None)
              self.arglist[offset] = value
          
        finally :
          asqBuild.logger.decDepthTrace()


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def _attributeNonZero(self, name) :
        """\
          bool _attributeNonZero(string name)
          
          Callback used by self.__nonzero__()
          Check that attribute is not empty.
          Should be overriden to set the behavior for children classes.
          
          param name                  attribute name
          return                      is attribute NOT empty ?
        """
        if 'arglist' != name :
          return super(rawTaskItem, self)._attributeNonZero(name)
        else :
          return bool(self.arglist)


    def _attributeDebug(self, name) :
        """\
          void _attributeDebug(string name)
          
          Callback used by self.debug()
          Prints out debug information for given attribute.
          Should be overriden to set the behavior for children classes.
          
          param name                  attribute name
        """
        if 'arglist' != name :
          super(rawTaskItem, self)._attributeDebug(name)
        elif not self.arglist :
          # empty arguments list
          self._debugKeyVal(name, self.__dict__[name])
        else :
          asqBuild.logger.debug(name)
          asqBuild.logger.incDepthDebug()
          for i in xrange(len(self.arglist)) :
            self._debugKeyVal('arg%d' % (i,), self.arglist[i])
          asqBuild.logger.decDepthDebug()


    def _attributeCheck(self, status, name) :
        """\
          void _attributeCheck(object status, string name)
          
          Callback used by self.check(...)
          Checks the value of attribute; Appends error or warning
          messages to given check status.
          Should be overriden to set the behavior for children classes.
          
          param status                checkResult object
          param name                  attribute name
        """
        if 'arglist' != name :
          super(rawTaskItem, self)._attributeCheck(status, name)
        else :
          buffer = filter(None, self.arglist)
          if not buffer :
            status.addMsgError('argList is empty')
          elif not os.path.isabs(buffer[0]) :
            # maybe a built-in shell command ?
            pass
          elif not os.path.isfile(buffer[0]) :
            status.addMsgError('cannot find executable')


    def _attributeToList(self, aList, name) :
        """\
          void _attributeToList(list aList, string name)
          
          Callback used by self.toList(...)
          Appends attribute to given "aList" list.
          Should be overriden to set the behavior for children classes.
          
          param aList                 list of attributes
          param name                  attribute name
        """
        if 'arglist' != name :
          super(rawTaskItem, self)._attributeToList(aList, name)
        else :
          aList.append( ('arglen', self.arglen) )
          for i in xrange(self.arglen) :
            aList.append( ('arg%d' % (i,), self.arglist[i]) )


    def _attributeNormalize(self, name) :
        """\
          void _attributeNormalize(string name)
          
          Callback used by self.normalize()
          Normalizes attribute : ensures that its type is correct.
          Should be overriden to set the behavior for children classes.
          
          param name                  attribute name
        """
        if   'update_environ' != name :
          super(rawTaskItem, self)._attributeNormalize(name)
        elif isinstance(self.update_environ, bool) :
          pass
        elif not isinstance(self.update_environ, basestring) :
          object.__setattr__(self, 'update_environ', bool(self.update_environ))
        else :
          buffer = asqTypes.asBoolean(self.update_environ)
          object.__setattr__(self, 'update_environ', buffer)


    def _attributeReset(self, name) :
        """\
          void _attributeReset(string name)
          
          Callback used by self.reset()
          Resets attribute value.
          Should be overriden to set the behavior for children classes.
          
          param name                  attribute name
        """
        if   'update_environ' == name :
          object.__setattr__(self, 'update_environ' , False)
        elif 'arglist' != name :
          super(rawTaskItem, self)._attributeReset(name)
        elif not hasattr(self, 'arglist') :
          object.__setattr__(self, 'arglist', list())
        else :
          self.arglist[:] = []


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def _attributeMerge(self, name, value) :
        """\
          void _attributeMerge(string name, var value)
          
          Callback used by mergeWithList(...)
          Merge attribut value with given one. The arglist should NOT be
          merged !
          Should be overriden to set the behavior for children classes.
          
          param name                  attribute name
          param value                 attribute value
        """
        if 'arglen' == name :
          pass
        elif self.reArgItem.match(name) :
          pass
        else :
          super(rawTaskItem, self)._attributeMerge(name, value)


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def _antAction(self) :
        """\
          str _antAction(void)
          
          Callback used by antDisplay()
          Returns a short string explaining the task's action.
          Should be overriden to set the behavior for children classes.
          Disabled and non valid tasks are already handled.
          
          return                      task's action
        """
        result = super(rawTaskItem, self)._antAction()
        
        # test if "result" is an empty string
        if not asqTypes.isNonEmptyInstance(result, basestring) :
          buffer = ' '.join(filter(None, self.arglist))
          result = asqString.truncateString(buffer, 52, '...', ' ')
        
        return result


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def _fillCmdLine(self, aCmdLine) :
        """\
          void _fillCmdLine(object aCmdLine)
          
          Callback used by toCmdLine()
          Build the task command line, task is assumed valid.
          Should be overriden to set the behavior for children classes.
          
          param aCmdLine              cmdLine object
        """
        asqBuild.logger.trace('rawTaskItem._fillCmdLine(aCmdLine)')
        asqBuild.logger.incDepthTrace()
        try :
          
          buffer = filter(None, self.arglist)
          try :
            aCmdLine.extend(buffer)
          finally :
            del buffer
          
        finally :
          asqBuild.logger.decDepthTrace()


    def _fillTmpFile(self, aFile) :
        """\
          void _fillTmpFile(object aFile)
          
          Callback used by buildTmpFile()
          Dumps config values to given file object, which must have
          been opened.
          Should be overriden to set the behavior for children classes.
          
          param aFile                 file object
        """
        assert self.update_environ
        source = self.__getTemplate()
        assert os.path.isfile(source)
        
        aFile.write(asqFile.readFile(source))


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def isValid(self) :
        """\
          bool isValid(void)
          
          Tells whether or not the task is "valid", id est, if mandatory
          attributes are set; an empty task is not valid, but an invalid
          task may not be empty ;)
          
          return                      is task valid
        """
        asqBuild.logger.trace('rawTask.isValid()')
        asqBuild.logger.incDepthTrace()
        try :
          
          if not super(rawTaskItem, self).isValid() :
            return False
          else :
            return bool(self.arglist)
          
        finally :
          asqBuild.logger.decDepthTrace()


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def __getTemplate(self) :
        """\
          string __getTemplate(void)
          
          Returns the absolute path to the template file, according
          to the underlying platform.
          
          return                      path to the more suited template
        """
        if -1 == asqWin.getWindowsPlatform() :
          raise asqBuildCore.taskError('TODO : rawTaskItem.__getTemplate()', self._task)
        else :
          return os.path.join(asqPath.directory(__file__), BAT_TEMPLATE)


  # Getters - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def _getArgLen(self) :
        """\
          int _getArgLen(void)
          
          Getter - arglen property
        """
        return len(self.arglist)


  # Setters - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # Properties  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    arglen    = property(
                  doc  = "length of dynamic arguments list",
                  fget = _getArgLen,
                  fset = None,
                  fdel = None )


  # /class rawTaskItem  - - - - - - - - - - - - - - - - - - - - - - - - - - - -


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


class rawTaskList(rawTask, asqBuildCore.taskList) :
    """\
      A list of rawTaskItems, the list defines "default" attributes that
      each single item can override; if an item doesn't set an attribute,
      then the list's values will be used.
    """

    # task item class
    taskClass   = rawTaskItem

    # Properties defined for that task type and its descendant.
    # Note : attribute names should be "lower case" only.
    attributes    = (
        'taskname',             # task name (should held section name)
        'count',                # task item count
        'tasktype',             # task type as a string
        'enabled',              # is task active ?
        'workdir',              # task base directory
        'comments',             # about this task
        
        #~ 'arglist',              # dynamic arguments list
        'update_environ',       # update system env after task execution ?
        
        'tmpfile',              # command line wrapper
        'envfile',              # OS environment dump
        'others'                # unrecognized attributes
      )

  # Getters - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # Setters - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # Properties  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # /class rawTaskList  - - - - - - - - - - - - - - - - - - - - - - - - - - - -


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

if '__main__' == __name__ :
  print __file__
  print __doc__


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -