#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.7 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

import  logging
import  os

import  py_netasq.commonlib.asqDebug            as asqDebug
import  py_netasq.commonlib.asqLogging          as asqLogging
import  py_netasq.commonlib.asqPath             as asqPath
import  py_netasq.commonlib.asqRepr             as asqRepr

import  py_netasq.building                      as asqBuild
import  py_netasq.building.core                 as asqBuildCore
import  py_netasq.building.tasks                as asqBuildTasks


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

DBG_LOGGER = asqBuild.logger
DBG_LOGLVL = logging.INFO

# globally enable TRACE logging message
asqBuild.logger.excludeLvl.append(asqLogging.TRACE)

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

aTaskItemDebug = asqDebug.objectDebug(asqBuildTasks.rawTaskItem, 'aTaskItemDebug')
aTaskItemDebug.logger           = DBG_LOGGER
aTaskItemDebug.logLevel         = DBG_LOGLVL

aTaskHandlerDebug = asqDebug.objectDebug(asqBuildTasks.rawTaskHandler, 'aTaskHandlerDebug')
aTaskHandlerDebug.logger        = DBG_LOGGER
aTaskHandlerDebug.logLevel      = DBG_LOGLVL

asqRepr.aRepr.logger            = DBG_LOGGER
asqRepr.aRepr.logLevel          = logging.DEBUG
asqRepr.aRepr.maxstring         = 40
asqRepr.aRepr.maxlist           = 15

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# "good" task list settings
item_settings = {
    'arg0'      : 'move',
    'arg1'      : r'.\dummy.txt',
    'arg2'      : r'.\tummy.log',
  }

# "wrong"/dummy task item settings
item_dummy     = {
    'zobi'      : 'biroutte',
  }


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# cannon fodder
file('./dummy.txt', 'w+')
assert os.path.exists('./dummy.txt')

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

print ''

#~ aTaskItemDebug.classAttributes()
#~ print ''
#~ aTaskItemDebug.objectInit(enabled=False)
#~ aTaskItemDebug.objectDel()

#~ print ''
#~ print '# - - - - - - - - - - - - - - - - - - -'
#~ print ''


aTaskItemDebug.objectInit(enabled=True)
#~ aTaskItemDebug.objectCallFunc('debug')
print ''
aTaskItemDebug.objectBatchSetAttr(item_settings)
aTaskItemDebug.objectBatchSetAttr(item_dummy)


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# check that values stand where they are expected to be
for (key, val) in item_settings.iteritems() :
  buffer = aTaskItemDebug.objectGetAttr(key)
  assert val == buffer  , "attribute `%s` - got %s expected %s" % (key, repr(buffer), repr(val))

# check others dictionnary
buffer = aTaskItemDebug.objectGetAttr('others')
assert isinstance(buffer, dict), "task.others : dictionnary expected"
buffer = buffer.keys()
for key in item_dummy.iterkeys() :
  assert key in buffer, "`%s` missing from the 'others' dictionnary." % (key, )

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


#~ print ''
#~ aTaskItemDebug.objectCallFunc('debug')
print ''

aTaskItemDebug.objectCallFunc('completePaths', baseDir=None)
#~ aTaskItemDebug.objectCallFunc('debug')

print ''
print '# - - - - - - - - - - - - - - - - - - -'
print ''


#~ buffer = aTaskItemDebug.objectCallFunc('check')
#~ buffer.debug()

#~ print ''
#~ print '# - - - - - - - - - - - - - - - - - - -'
#~ print ''


#~ aTaskItemDebug.objectCallFunc('reset')
#~ print ''
#~ aTaskItemDebug.objectCallFunc('debug')
#~ print '# - - - - - - - - - - - - - - - - - - -'
#~ print ''


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


#~ aTaskHandlerDebug.classAttributes()
#~ print ''
#~ aTaskHandlerDebug.objectInit(aTask=None)
#~ aTaskHandlerDebug.objectDel()

#~ print ''
#~ print '# - - - - - - - - - - - - - - - - - - -'
#~ print ''

aTaskHandlerDebug.objectInit(aTask=aTaskItemDebug.object)

buffer = aTaskHandlerDebug.objectCallFunc('task.check')
buffer.report(DBG_LOGGER)


print ''
print '# - - - - - - - - - - - - - - - - - - -'
print ''


workdir = os.getcwd()


buffer = aTaskHandlerDebug.objectCallFunc('task.antDisplay')
DBG_LOGGER.debug(buffer)
#~ asqRepr.representation(buffer)


buffer = aTaskHandlerDebug.objectCallFunc('run')
asqRepr.representation(buffer)

#~ buffer = aTaskHandlerDebug.objectGetAttr('output')
#~ asqRepr.representation(buffer)

assert os.getcwd() == workdir, "failed to restore previous work directory"


assert not os.path.exists('./dummy.txt')
assert os.path.exists('./tummy.log')
asqPath.delete('./tummy.log', True)


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -