#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
A delphi building utility: Wrapper around delphi compiler,
with custom config file support.

Require
  Python        2.2

Classes
  class         mailTaskHandler(object aTask, object logger)
                  extends py_netasq.building.core::taskHandler
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.11 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

import  smtplib

from    py_netasq.commonlib     import asqMail

from    py_netasq               import building as asqBuild
from    py_netasq.building      import core     as asqBuildCore

import  tasks


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

class mailTaskHandler(asqBuildCore.taskHandler) :
    """\
      Wrapper around delphi compiler, with custom config file
      support. Settings have to be set through object's "task"
      (class mailTaskItem) attribute.
    """

    # task class
    taskClass = tasks.mailTaskItem

  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def run(self, aTask=None, raw=False, *arglist, **argdict) :
        """\
          var run(object aTask, bool raw, *arglist, **argdict)
          
          Execute inner task line, if "task" is given, it will replace
          the current taskItem instance; The shell status is returned,
          'None' if execution was succesful, any other value means
          failure. If "raw" is set to True, then no peculiar operation
          should be done upon the command's output.
          
          Two extra arguments are expected :
          - "sucessful" a boolean value which sets the mail subject
          - "mailtext" a string value which sets the mail content
          
          param aTask                 taskItem to execute.
                                       defaults to None
          param raw                   disable output formatting
                                        defaults to False
          param *arglist              extra parameters.
          param **argdict             extra named parameters.
          return                      shell status
        """
        asqBuild.logger.trace('mailTaskHandler.run(aTask, %s)', str(raw))
        asqBuild.logger.incDepthTrace()
        try :
          
          # provides default values for excpected arguments
          argdict.setdefault('succesful', False)
          argdict.setdefault('mailtext' , '')
          
          return super(mailTaskHandler, self).run(aTask, raw, *arglist, **argdict)
          
        finally :
          asqBuild.logger.decDepthTrace()


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def _execute(self, cmdStr, raw, *arglist, **argdict) :
        """\
          var _execute(string cmdStr, bool raw, *arglist, **argdict)
          
          Execute inner command line and return the shell status.
          Each line from stdout and stderr will be decoded and processed,
          i.e. lines will go through _decodeOutput() and _processOutput().
          
          param cmdStr                command as a string to execute.
          param raw                   disable output formatting
          param *arglist              extra parameters.
          param **argdict             extra named parameters.
          return                      shell status
        """
        asqBuild.logger.trace('mailTaskHandler._execute(%s, %s)' % (cmdStr, str(raw)))
        asqBuild.logger.incDepthTrace()
        try :
          
          assert 'succesful' in argdict, "missing argument : bool succesful"
          assert 'mailtext'  in argdict, "missing argument : string mailtext"
          
          #~ self._processInput(cmdStr, raw, *arglist, **argdict)
          try :
            message = self._task.toMessage(argdict['succesful'], argdict['mailtext'])
            self.__sendMessage(message, self._task.smtphost)
            
          except (smtplib.SMTPHeloError, smtplib.SMTPDataError, smtplib.SMTPSenderRefused, smtplib.SMTPRecipientsRefused), e :
            raise asqBuildCore.taskHandlerError(-1, self.output, self._task)
         
        finally :
          asqBuild.logger.decDepthTrace()


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def __sendMessage(self, message, host) :
        """\
          void sendMailMessage(object message, string host)
          
          Send given email.Message object using 'host' as the SMTP server
          address. Most smtp exceptions are caught, then nicely formated,
          then re-raised.
          
          param message               message to send
          param host                  smtp host, defaults to SMTP_HOST
        """
        try :
          asqMail.sendMailMessage(message, host)
          
        except smtplib.SMTPHeloError, e :
          buffer = list()
          buffer.append('SMTP : Wrong "HELO" reply from server')
          buffer.append('(%d %s)' % (e.smtp_code, e.smtp_error))
          self._processOutput(' '.join(buffer), raw=False)
          raise
        
        except smtplib.SMTPDataError, e :
          buffer = list()
          buffer.append('SMTP : message refused by server')
          buffer.append('(%d %s)' % (e.smtp_code, e.smtp_error))
          self._processOutput(' '.join(buffer), raw=False)
          raise
        
        except smtplib.SMTPSenderRefused, e :
          buffer = list()
          buffer.append('SMTP : Refused sender')
          buffer.append('%s (%d %s)' % (e.sender, e.smtp_code, e.smtp_error))
          self._processOutput(' '.join(buffer), raw=False)
          raise
        
        except smtplib.SMTPRecipientsRefused, e :
          buffer = list()
          buffer.append('SMTP : Refused recipient(s)')
          # one entry for each recipient that was refused. Each entry
          # contains a tuple of the SMTP error code and the accompanying
          # error message sent by the server.
          for (key, val) in e.recipents.iteritems() :
            buffer.append('\n- %s (%d %s)' % (key, val[0], val[1]))
          self._processOutput(' '.join(buffer), raw=False)
          raise


  # Getters - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # Setters - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # Properties  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # /class mailTaskHandler  - - - - - - - - - - - - - - - - - - - - - - - - - -


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

if '__main__' == __name__ :
  print __file__
  print __doc__


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -