#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
A delphi building utility: Wrapper for delete tasks. Actually,
this one does not really behave as a taskHandler, since no
shell command are used (none could fulfill the requirement).

Require
  Python        2.2

Classes
  class         delTaskHandler(object aTask, object logger)
                  extends py_netasq.building.core::taskHandler
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.9 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

import  glob

from    py_netasq.commonlib     import asqPath, asqSequence

from    py_netasq               import building as asqBuild
from    py_netasq.building      import core     as asqBuildCore

import  tasks


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

class delTaskHandler(asqBuildCore.taskHandler) :
    """\
      Wrapper for delete tasks. Settings have to be set through object's
      "task" (class delTaskItem) attribute.
    """

    # task class
    taskClass = tasks.delTaskItem

  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def _execute(self, cmdStr, raw, *arglist, **argdict) :
        """\
          var _execute(string cmdStr, bool raw, *arglist, **argdict)
          
          Execute inner command line and return the shell status.
          Each line from stdout and stderr will be decoded and processed,
          i.e. lines will go through _decodeOutput() and _processOutput().
          
          param cmdStr                command as a string to execute.
          param raw                   disable output formatting
          param *arglist              extra parameters.
          param **argdict             extra named parameters.
          return                      shell status
        """
        asqBuild.logger.trace('delTaskHandler._execute(%s, %s)' % (cmdStr, str(raw)))
        asqBuild.logger.incDepthTrace()
        try :
          
          #~ self._processInput(cmdStr, raw, *arglist, **argdict)
          try :
            remove = glob.glob(self._task.target)
            if self._task.exclude is not None :
              buffer = self.__listExcluded(self._task.exclude)
              remove[:] = asqSequence.difference(remove, buffer)
            for item in remove :
              asqPath.delete(item, force=True)
              self._processOutput('deleted `%s`' % (item, ), raw, *arglist, **argdict)
          except OSError, e :
            # append exception message to the 'output' list
            self._processOutput(str(e), raw=False, *arglist, **argdict)
            return -1
          else :
            return None
         
        finally :
          asqBuild.logger.decDepthTrace()


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def __listExcluded(self, exclude) :
        """\
          list __listExcluded(string exclude)
          
          Lists all excluded items matching one of the 'exclude' paths.
          'exclude' parameter can hold more than a single path value
          e.g. c:\foo\[0-9].*;d:\bar\*.txt
          
          param exclude               exclude masks
          return                      list of excluded items paths
        """
        result = list()
        
        for item in exclude.split(';') :
          result.extend( glob.glob(item) )
        
        return result


  # Getters - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # Setters - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # Properties  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # /class delTaskHandler - - - - - - - - - - - - - - - - - - - - - - - - - - -


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

if '__main__' == __name__ :
  print __file__
  print __doc__


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -