#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.4 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

import  logging

import  py_netasq.commonlib.asqDebug            as asqDebug
import  py_netasq.commonlib.asqLogging          as asqLogging
import  py_netasq.commonlib.asqRepr             as asqRepr

import  py_netasq.building                      as asqBuild
import  py_netasq.building.core                 as asqBuildCore
import  py_netasq.building.tasks                as asqBuildTasks


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

DBG_LOGGER = asqBuild.logger
DBG_LOGLVL = logging.INFO

# globally disable TRACE logging message
asqBuild.logger.excludeLvl.append(asqLogging.TRACE)

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

aTaskItemDebug = asqDebug.objectDebug(asqBuildTasks.delTaskItem, 'aTaskItemDebug')
aTaskItemDebug.logger           = DBG_LOGGER
aTaskItemDebug.logLevel         = DBG_LOGLVL

asqRepr.aRepr.logger            = DBG_LOGGER
asqRepr.aRepr.logLevel          = logging.DEBUG
asqRepr.aRepr.maxstring         = 40
asqRepr.aRepr.maxlist           = 15


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# accurate task settings
item_settings = {
  }

# dummy task settings
item_dummy     = {
    'workDir'   : '.',
    'logFile'   : r'..\logfile.log',
    'zobi'      : 'biroutte',
  }


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


print ''

#~ aTaskItemDebug.classAttributes()
#~ print ''
#~ aTaskItemDebug.objectInit(enabled=False)
#~ aTaskItemDebug.objectDel()

#~ print ''
#~ print '# - - - - - - - - - - - - - - - - - - -'
#~ print ''


aTaskItemDebug.objectInit(enabled=True)
#~ aTaskItemDebug.objectCallFunc('debug')
print ''
aTaskItemDebug.objectBatchSetAttr(item_settings)
aTaskItemDebug.objectBatchSetAttr(item_dummy)


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# check that values stand where they are expected to be
for (key, val) in item_settings.iteritems() :
  buffer = aTaskItemDebug.objectGetAttr(key)
  assert val == buffer  , "attribute `%s` - got %s expected %s" % (key, repr(buffer), repr(val))

# check others dictionnary
buffer = aTaskItemDebug.objectGetAttr('others')
assert isinstance(buffer, dict), "task.others : dictionnary expected"
buffer = buffer.keys()
for key in item_dummy.iterkeys() :
  assert key in buffer, "`%s` missing from the 'others' dictionnary." % (key, )

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


print ''

#~ aTaskItemDebug.objectCallFunc('debug')
#~ print ''

#~ buffer = aTaskItemDebug.objectCallFunc('check')
#~ asqRepr.representation(buffer)
#~ buffer.debug()
#~ print ''


aTaskItemDebug.objectCallFunc('completePaths', baseDir=None)
print ''
print '# - - - - - - - - - - - - - - - - - - -'
print ''


aTaskItemDebug.objectCallFunc('debug')
print ''

buffer = aTaskItemDebug.objectCallFunc('check')
#~ asqRepr.representation(buffer)
buffer.debug()

print ''
print '# - - - - - - - - - - - - - - - - - - -'
print ''


#~ aTaskItemDebug.objectCallFunc('reset')
#~ print ''
#~ aTaskItemDebug.objectCallFunc('debug')
#~ print '# - - - - - - - - - - - - - - - - - - -'
#~ print ''


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -