#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.8 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

import  glob
import  logging
import  os

from    py_netasq.commonlib             import asqDebug, asqLogging, asqRepr
from    py_netasq.commonlib             import asqSequence

import  py_netasq.building                      as asqBuild
import  py_netasq.building.core                 as asqBuildCore
import  py_netasq.building.tasks                as asqBuildTasks


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

DBG_LOGGER = asqBuild.logger
DBG_LOGLVL = logging.INFO

# globally disable TRACE logging message
asqBuild.logger.excludeLvl.append(asqLogging.TRACE)

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

aTaskItemDebug = asqDebug.objectDebug(asqBuildTasks.delTaskItem, 'aTaskItemDebug')
aTaskItemDebug.logger           = DBG_LOGGER
aTaskItemDebug.logLevel         = DBG_LOGLVL

aTaskHandlerDebug = asqDebug.objectDebug(asqBuildTasks.delTaskHandler, 'aTaskHandlerDebug')
aTaskHandlerDebug.logger        = DBG_LOGGER
aTaskHandlerDebug.logLevel      = DBG_LOGLVL

asqRepr.aRepr.logger            = DBG_LOGGER
asqRepr.aRepr.logLevel          = logging.DEBUG
asqRepr.aRepr.maxstring         = 40
asqRepr.aRepr.maxlist           = 15


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

def processInput(value, raw, *arglist, **argdict) :
    DBG_LOGGER.debug('$ %s', value)


def processOutput(value, raw, *arglist, **argdict) :
    DBG_LOGGER.debug(value)


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# accurate task settings
item_settings = {
    'workdir'           : '.',
  }

# dummy task settings
item_dummy     = {
  }


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# cannon fodder
file('./dummy.txt', 'w+')
assert os.path.exists('./dummy.txt')

file('./dummy.dll', 'w+')
assert os.path.exists('./dummy.dll')

file('./buffy.dll', 'w+')
assert os.path.exists('./buffy.dll')

file('./keep.dll', 'w+')
assert os.path.exists('./keep.dll')

file('./stay.dll', 'w+')
assert os.path.exists('./stay.dll')

file('./exclude.dll', 'w+')
assert os.path.exists('./exclude.dll')


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


print ''

#~ aTaskHandlerDebug.classAttributes()
#~ print ''
#~ aTaskHandlerDebug.objectInit(aTask=None)
#~ aTaskHandlerDebug.objectDel()

#~ print ''
#~ print '# - - - - - - - - - - - - - - - - - - -'
#~ print ''

aTaskHandlerDebug.objectInit(aTask=None)

buffer = aTaskHandlerDebug.objectCallFunc('task.check')
buffer.report(DBG_LOGGER)

aTaskHandlerDebug.objectSetAttr('onProcessInput'  , processInput)
aTaskHandlerDebug.objectSetAttr('onProcessOutput' , processOutput)



print ''
print '# - - - - - - - - - - - - - - - - - - -'
print ''


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


#~ aTaskItemDebug.classAttributes()
#~ print ''
#~ aTaskItemDebug.objectInit(enabled=False)
#~ aTaskItemDebug.objectDel()

#~ print ''
#~ print '# - - - - - - - - - - - - - - - - - - -'
#~ print ''


aTaskItemDebug.objectInit(enabled=True)
#~ aTaskItemDebug.objectCallFunc('debug')
print ''
aTaskItemDebug.objectBatchSetAttr(item_settings)
aTaskItemDebug.objectBatchSetAttr(item_dummy)


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# check that values stand where they are expected to be
for (key, val) in item_settings.iteritems() :
  buffer = aTaskItemDebug.objectGetAttr(key)
  assert val == buffer  , "attribute `%s` - got %s expected %s" % (key, repr(buffer), repr(val))

# check others dictionnary
buffer = aTaskItemDebug.objectGetAttr('others')
assert isinstance(buffer, dict), "task.others : dictionnary expected"
buffer = buffer.keys()
for key in item_dummy.iterkeys() :
  assert key in buffer, "`%s` missing from the 'others' dictionnary." % (key, )

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


#~ print ''
#~ aTaskItemDebug.objectCallFunc('debug')
print ''

aTaskHandlerDebug.objectSetAttr('task', aTaskItemDebug.object)
print ''

aTaskHandlerDebug.objectSetAttr('task.target', 'dummy.txt')
aTaskHandlerDebug.objectCallFunc('task.completePaths', baseDir=None)

#~ print ''
#~ aTaskHandlerDebug.objectCallFunc('debug')
print ''

#~ buffer = aTaskHandlerDebug.objectCallFunc('task.check')
#~ asqRepr.representation(buffer)
#~ print ''


#~ buffer = aTaskHandlerDebug.objectCallFunc('task.antDisplay')
#~ DBG_LOGGER.debug(buffer)
#~ asqRepr.representation(buffer)


buffer = aTaskHandlerDebug.objectCallFunc('run')
asqRepr.representation(buffer)


remove = glob.glob(aTaskHandlerDebug.object.task.target)
if aTaskHandlerDebug.object.task.exclude is not None :
  buffer = list()
  for item in aTaskHandlerDebug.object.task.exclude.split(';') :
    buffer.extend( glob.glob(item) )
  remove[:] = asqSequence.difference(remove, buffer)

assert not remove, "target missed"


print ''
print '# - - - - - - - - - - - - - - - - - - -'
print ''


aTaskHandlerDebug.objectSetAttr('task.target', '*.dll')
aTaskHandlerDebug.objectSetAttr('task.exclude', 'keep.*;stay.*;exclude.*')
aTaskHandlerDebug.objectCallFunc('task.completePaths', baseDir=None)

#~ print ''
#~ aTaskHandlerDebug.objectCallFunc('debug')
print ''

#~ buffer = aTaskHandlerDebug.objectCallFunc('task.check')
#~ asqRepr.representation(buffer)
#~ print ''


#~ buffer = aTaskHandlerDebug.objectCallFunc('task.antDisplay')
#~ DBG_LOGGER.debug(buffer)
#~ asqRepr.representation(buffer)


buffer = aTaskHandlerDebug.objectCallFunc('run')
asqRepr.representation(buffer)

remove = glob.glob(aTaskHandlerDebug.object.task.target)
if aTaskHandlerDebug.object.task.exclude is not None :
  buffer = list()
  for item in aTaskHandlerDebug.object.task.exclude.split(';') :
    buffer.extend( glob.glob(item) )
  remove[:] = asqSequence.difference(remove, buffer)

assert not remove, "target missed"


print ''
print '# - - - - - - - - - - - - - - - - - - -'
print ''


aTaskHandlerDebug.objectSetAttr('task.target', '*.dll')
aTaskHandlerDebug.objectSetAttr('task.exclude', 'keep.*')
aTaskHandlerDebug.objectCallFunc('task.completePaths', baseDir=None)

#~ print ''
#~ aTaskHandlerDebug.objectCallFunc('debug')
print ''

#~ buffer = aTaskHandlerDebug.objectCallFunc('task.check')
#~ asqRepr.representation(buffer)
#~ print ''


#~ buffer = aTaskHandlerDebug.objectCallFunc('task.antDisplay')
#~ DBG_LOGGER.debug(buffer)
#~ asqRepr.representation(buffer)


buffer = aTaskHandlerDebug.objectCallFunc('run')
asqRepr.representation(buffer)

remove = glob.glob(aTaskHandlerDebug.object.task.target)
if aTaskHandlerDebug.object.task.exclude is not None :
  buffer = list()
  for item in aTaskHandlerDebug.object.task.exclude.split(';') :
    buffer.extend( glob.glob(item) )
  remove[:] = asqSequence.difference(remove, buffer)

assert not remove, "target missed"


print ''
print '# - - - - - - - - - - - - - - - - - - -'
print ''


aTaskHandlerDebug.objectSetAttr('task.target', '*.dll')
aTaskHandlerDebug.objectSetAttr('task.exclude', None)
aTaskHandlerDebug.objectCallFunc('task.completePaths', baseDir=None)

#~ print ''
#~ aTaskHandlerDebug.objectCallFunc('debug')
print ''

#~ buffer = aTaskHandlerDebug.objectCallFunc('task.check')
#~ asqRepr.representation(buffer)
#~ print ''


#~ buffer = aTaskHandlerDebug.objectCallFunc('task.antDisplay')
#~ DBG_LOGGER.debug(buffer)
#~ asqRepr.representation(buffer)


buffer = aTaskHandlerDebug.objectCallFunc('run')
asqRepr.representation(buffer)

remove = glob.glob(aTaskHandlerDebug.object.task.target)
if aTaskHandlerDebug.object.task.exclude is not None :
  buffer = list()
  for item in aTaskHandlerDebug.object.task.exclude.split(';') :
    buffer.extend( glob.glob(item) )
  remove[:] = asqSequence.difference(remove, buffer)

assert not remove, "target missed"


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -