#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.6 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

import  logging
import  os

import  py_netasq.commonlib.asqDebug            as asqDebug
import  py_netasq.commonlib.asqLogging          as asqLogging
import  py_netasq.commonlib.asqPath             as asqPath
import  py_netasq.commonlib.asqRepr             as asqRepr

import  py_netasq.building                      as asqBuild
import  py_netasq.building.core                 as asqBuildCore
import  py_netasq.building.tasks                as asqBuildTasks


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

DBG_LOGGER = asqBuild.logger
DBG_LOGLVL = logging.INFO

# globally disable TRACE logging message
asqBuild.logger.excludeLvl.append(asqLogging.TRACE)

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

aTaskItemDebug = asqDebug.objectDebug(asqBuildTasks.dccTaskItem, 'aTaskItemDebug')
aTaskItemDebug.logger           = DBG_LOGGER
aTaskItemDebug.logLevel         = DBG_LOGLVL

aTaskHandlerDebug = asqDebug.objectDebug(asqBuildTasks.dccTaskHandler, 'aTaskHandlerDebug')
aTaskHandlerDebug.logger        = DBG_LOGGER
aTaskHandlerDebug.logLevel      = DBG_LOGLVL

asqRepr.aRepr.logger            = DBG_LOGGER
asqRepr.aRepr.logLevel          = logging.DEBUG
asqRepr.aRepr.maxstring         = 60
asqRepr.aRepr.maxlist           = 15


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# accurate task settings
item_settings = {
    'compiler'  : r'C:\Coding\Borland\Delphi7\Bin\DCC32.EXE',
    'project'   : r'.\src\Project1.dpr',
    'bindir'    : r'.\bin',
    'dcudir'    : r'.\dcu',
    'cmdextra'  : r'-B -Q',

    'mad_patch' : r'C:\Program Files\Components\madCollection\madExcept\Tools\madExceptPatch.exe',
  }



# dummy task settings
item_dummy     = {
    'logFile' : r'..\logfile.log',
    'zobi'    : 'biroutte',
  }


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


print ''

#~ aTaskItemDebug.classAttributes()
#~ print ''
#~ aTaskItemDebug.objectInit(enabled=False)
#~ aTaskItemDebug.objectDel()

#~ print ''
#~ print '# - - - - - - - - - - - - - - - - - - -'
#~ print ''


aTaskItemDebug.objectInit(enabled=True)
#~ aTaskItemDebug.objectCallFunc('debug')
print ''
aTaskItemDebug.objectBatchSetAttr(item_settings)
aTaskItemDebug.objectBatchSetAttr(item_dummy)


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# check that values stand where they are expected to be
for (key, val) in item_settings.iteritems() :
  buffer = aTaskItemDebug.objectGetAttr(key)
  assert val == buffer  , "attribute `%s` - got %s expected %s" % (key, repr(buffer), repr(val))

# check others dictionnary
buffer = aTaskItemDebug.objectGetAttr('others')
assert isinstance(buffer, dict), "task.others : dictionnary expected"
buffer = buffer.keys()
for key in item_dummy.iterkeys() :
  assert key in buffer, "`%s` missing from the 'others' dictionnary." % (key, )

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


# trash bin and dcu directories for a clean build test
if aTaskItemDebug.objectGetAttr('bindir') is None :
  pass
elif os.path.exists(aTaskItemDebug.object.bindir) :
  asqPath.delete(aTaskItemDebug.object.bindir, True)

if aTaskItemDebug.objectGetAttr('dcudir') is None :
  pass
elif os.path.exists(aTaskItemDebug.object.dcudir) :
  asqPath.delete(aTaskItemDebug.object.dcudir, True)


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


#~ print ''
#~ aTaskItemDebug.objectCallFunc('debug')
print ''

aTaskItemDebug.objectCallFunc('completePaths', baseDir=None)
#~ aTaskItemDebug.objectCallFunc('debug')

print ''
print '# - - - - - - - - - - - - - - - - - - -'
print ''


#~ buffer = aTaskItemDebug.objectCallFunc('check')
#~ asqRepr.representation(buffer)

#~ print ''
#~ print '# - - - - - - - - - - - - - - - - - - -'
#~ print ''


#~ aTaskItemDebug.objectCallFunc('reset')
#~ print ''
#~ aTaskItemDebug.objectCallFunc('debug')
#~ print '# - - - - - - - - - - - - - - - - - - -'
#~ print ''


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


#~ aTaskHandlerDebug.classAttributes()
#~ print ''
#~ aTaskHandlerDebug.objectInit(aTask=None)
#~ aTaskHandlerDebug.objectDel()

#~ print ''
#~ print '# - - - - - - - - - - - - - - - - - - -'
#~ print ''

aTaskHandlerDebug.objectInit(aTask=aTaskItemDebug.object)

buffer = aTaskHandlerDebug.objectCallFunc('task.check')
buffer.report(DBG_LOGGER)


print ''
print '# - - - - - - - - - - - - - - - - - - -'
print ''


workdir = os.getcwd()

buffer = aTaskHandlerDebug.objectCallFunc('task.debug')
asqRepr.representation(buffer)


buffer = aTaskHandlerDebug.objectCallFunc('task.antDisplay')
DBG_LOGGER.debug(buffer)
#~ asqRepr.representation(buffer)


buffer = aTaskHandlerDebug.objectCallFunc('run')
asqRepr.representation(buffer)

#~ buffer = aTaskHandlerDebug.objectGetAttr('output')
#~ asqRepr.representation(buffer)

assert os.getcwd() == workdir, "failed to restore previous work directory"


# cleanup the mess
#~ if aTaskItemDebug.objectGetAttr('bindir') is None :
  #~ pass
#~ elif os.path.exists(aTaskItemDebug.object.bindir) :
  #~ asqPath.delete(aTaskItemDebug.object.bindir, True)

if aTaskItemDebug.objectGetAttr('dcudir') is None :
  pass
elif os.path.exists(aTaskItemDebug.object.dcudir) :
  asqPath.delete(aTaskItemDebug.object.dcudir, True)


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -