#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
A delphi building utility: Wrapper around cvs client.

Require
  Python        2.2

Classes
  class         cvsTaskHandler(object aTask, object logger)
                  extends py_netasq.building.core::taskHandler
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.7 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

import  os

from    py_netasq.commonlib     import asqPath

from    py_netasq               import building as asqBuild
from    py_netasq.building      import core     as asqBuildCore

import  tasks


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

class cvsTaskHandler(asqBuildCore.taskHandler) :
    """\
      Wrapper around cvs client. Settings have to be set through
      object's "task" (class cvsTaskItem) attribute.
    """

    # task class
    taskClass   = tasks.cvsTaskItem

    # shell environment variable : CVS_RSH
    ENV_CVS_RSH = 'CVS_RSH'

  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def __init__(self, aTask=None) :
        """\
          constructor taskHandler(object aTask)
          
          Create a new object intended to ease command line execution.
          
          param aTask                 task to execute.
                                       defaults to None
        """
        super(cvsTaskHandler, self).__init__(aTask)
        self._initRsh = None


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def debug(self) :
        """\
          void debug(void)
          
          Prints out the main attributes values through the logging
          utility.
        """
        self._debugKeyVal('CVS_RSH', os.getenv(self.ENV_CVS_RSH, None))
        self._debugKeyVal('_initRsh', self._initRsh)
        super(cvsTaskHandler, self).debug()


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def _setup(self, *arglist, **argdict) :
        """\
          void _setup(*arglist, **argdict)
          
          Called right before the actual command execution; should be
          overidden to set up the execution environment.
          
          - Some cvs command ('update') has to be executed from within
           the destination directory, so we switch the current directory;
           If detination dir does not exist, it will be created, but an
           exception may be raised if directory creation is impossible
           (ex for MS windows: give a wrong drive letter).
          - CVS_RSH Environnement value has to be properly set.
          
          param *arglist              extra parameters.
          param **argdict             extra named parameters.
        """
        asqBuild.logger.trace('cvsTaskHandler._setup()')
        asqBuild.logger.incDepthTrace()
        try :
          
          super(cvsTaskHandler, self)._setup(*arglist, **argdict)
          self._pushCwd(self._task.destdir)
          
          if self._task.cvsrsh is None :
            self._initRsh = None
          else :
            self._initRsh = os.getenv(self.ENV_CVS_RSH, None)
            os.putenv(self.ENV_CVS_RSH, self._task.cvsrsh)
         
        finally :
          asqBuild.logger.decDepthTrace()


    def _teardown(self, *arglist, **argdict) :
        """\
          void _teardown(*arglist, **argdict)
          
          Called right after the actual command execution; should be
          overidden to clean up the execution environment.
          
          - switch back directory
          - restore previous CVS_RSH value
          
          param *arglist              extra parameters.
          param **argdict             extra named parameters.
        """
        asqBuild.logger.trace('cvsTaskHandler._teardown()')
        asqBuild.logger.incDepthTrace()
        try :
          
          self._popCwd()
          if self._initRsh is not None :
            os.putenv(self.ENV_CVS_RSH, self._initRsh)
          super(cvsTaskHandler, self)._teardown(*arglist, **argdict)
         
        finally :
          asqBuild.logger.decDepthTrace()


  # Getters - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # Setters - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # Properties  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # /class cvsTaskHandler - - - - - - - - - - - - - - - - - - - - - - - - - - -


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

if '__main__' == __name__ :
  print __file__
  print __doc__


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -