#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.7 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

import  logging
import  os

import  py_netasq.commonlib.asqDebug            as asqDebug
import  py_netasq.commonlib.asqLogging          as asqLogging
import  py_netasq.commonlib.asqPath             as asqPath
import  py_netasq.commonlib.asqRepr             as asqRepr

import  py_netasq.building                      as asqBuild
import  py_netasq.building.core                 as asqBuildCore
import  py_netasq.building.tasks                as asqBuildTasks


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

DBG_LOGGER = asqBuild.logger
DBG_LOGLVL = logging.INFO

# globally disable TRACE logging message
asqBuild.logger.excludeLvl.append(asqLogging.TRACE)

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

aTaskListDebug = asqDebug.objectDebug(asqBuildTasks.cvsTaskList, 'aTaskListDebug')
aTaskListDebug.logger           = DBG_LOGGER
aTaskListDebug.logLevel         = DBG_LOGLVL

aTaskItemDebug = asqDebug.objectDebug(asqBuildTasks.cvsTaskItem, 'aTaskItemDebug')
aTaskItemDebug.logger           = DBG_LOGGER
aTaskItemDebug.logLevel         = DBG_LOGLVL

aTaskHandlerDebug = asqDebug.objectDebug(asqBuildTasks.cvsTaskHandler, 'aTaskHandlerDebug')
aTaskHandlerDebug.logger        = DBG_LOGGER
aTaskHandlerDebug.logLevel      = DBG_LOGLVL

asqRepr.aRepr.logger            = DBG_LOGGER
asqRepr.aRepr.logLevel          = logging.DEBUG
asqRepr.aRepr.maxstring         = 40
asqRepr.aRepr.maxlist           = 15


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# accurate task settings
list_settings = {
    'workdir'   : '.',
    'destdir'   : r'.\dummy',
    'client'    : r'C:\Program Files\TortoiseCVS\cvs.exe',
    'command'   : 'checkout',
    'cvsroot'   : 'benoitk@10.0.0.128:/home/netasq/sources',
    'cvsrsh'    : 'ssh',
  }

# dummy task settings
list_dummy    = {
    'module'    : 'wrong value',
    'zobi'      : 'biroutte',
  }


# accurate task settings
item_settings = {
    'enabled'   : True,
    'module'    : 'IHM_Build',
  }

# dummy task settings
item_dummy     = {
  }


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


print ''

#~ aTaskListDebug.classAttributes()
#~ print ''
#~ aTaskListDebug.objectInit(enabled=False)
#~ aTaskListDebug.objectDel()

#~ print ''
#~ print '# - - - - - - - - - - - - - - - - - - -'
#~ print ''


aTaskListDebug.objectInit(enabled=True)
#~ aTaskListDebug.objectCallFunc('debug')
print ''
aTaskListDebug.objectBatchSetAttr(list_settings)
aTaskListDebug.objectBatchSetAttr(list_dummy)


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# check that values stand where they are expected to be
for (key, val) in list_settings.iteritems() :
  buffer = aTaskListDebug.objectGetAttr(key)
  assert val == buffer  , "attribute `%s` - got %s expected %s" % (key, repr(buffer), repr(val))

# check others dictionnary
buffer = aTaskListDebug.objectGetAttr('others')
assert isinstance(buffer, dict), "task.others : dictionnary expected"
buffer = buffer.keys()
for key in list_dummy.iterkeys() :
  assert key in buffer, "`%s` missing from the 'others' dictionnary." % (key, )

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

print ''

#~ aTaskListDebug.objectCallFunc('debug')
#~ print ''

buffer = aTaskListDebug.objectCallFunc('check')
#~ asqRepr.representation(buffer)
buffer.debug()

print ''
print '# - - - - - - - - - - - - - - - - - - -'
print ''



aTaskItemDebug.objectInit(enabled=False)
aTaskItemDebug.objectBatchSetAttr(item_settings)


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# check that values stand where they are expected to be
for (key, val) in item_settings.iteritems() :
  buffer = aTaskItemDebug.objectGetAttr(key)
  assert val == buffer  , "attribute `%s` - got %s expected %s" % (key, repr(buffer), repr(val))

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


#~ aTaskItemDebug.objectCallFunc('debug')
print ''
print '# - - - - - - - - - - - - - - - - - - -'
print ''


aTaskListDebug.objectCallFunc('append', aTaskItemDebug.object)
print ''

buffer = aTaskListDebug.objectCallFunc('check')
#~ asqRepr.representation(buffer)
buffer.debug()
print ''


aTaskItemDebug.objectCallFunc('mergeWithTask', aTaskListDebug.object)
aTaskItemDebug.objectCallFunc('completePaths', None)
#~ print ''
#~ aTaskItemDebug.objectCallFunc('debug')

print ''
print '# - - - - - - - - - - - - - - - - - - -'
print ''


aTaskHandlerDebug.objectInit(aTask=aTaskItemDebug.object)

buffer = aTaskHandlerDebug.objectCallFunc('task.check')
#~ asqRepr.representation(buffer)
buffer.debug()

print ''

workdir = os.getcwd()

#~ buffer = aTaskHandlerDebug.objectCallFunc('run')
#~ asqRepr.representation(buffer)

assert os.getcwd() == workdir, "failed to restore previous work directory"


# cleanup the mess
if aTaskItemDebug.objectGetAttr('destdir') is None :
  pass
elif os.path.exists(aTaskItemDebug.object.destdir) :
  asqPath.delete(aTaskItemDebug.object.destdir, True)


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -