#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.13 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

import  logging
import  os

from    py_netasq.commonlib     import asqDebug, asqLogging
from    py_netasq.commonlib     import asqPath, asqRepr

from    py_netasq               import building as asqBuild
from    py_netasq.building      import core     as asqBuildCore
from    py_netasq.building      import tasks    as asqBuildTasks


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

DBG_LOGGER = asqBuild.logger
DBG_LOGLVL = logging.INFO

# globally disable TRACE logging message
asqBuild.logger.excludeLvl.append(asqLogging.TRACE)

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

aTaskItemDebug = asqDebug.objectDebug(asqBuildTasks.cvsTaskItem, 'aTaskItemDebug')
aTaskItemDebug.logger           = DBG_LOGGER
aTaskItemDebug.logLevel         = DBG_LOGLVL

aTaskHandlerDebug = asqDebug.objectDebug(asqBuildTasks.cvsTaskHandler, 'aTaskHandlerDebug')
aTaskHandlerDebug.logger        = DBG_LOGGER
aTaskHandlerDebug.logLevel      = DBG_LOGLVL

asqRepr.aRepr.logger            = DBG_LOGGER
asqRepr.aRepr.logLevel          = logging.DEBUG
asqRepr.aRepr.maxstring         = 40
asqRepr.aRepr.maxlist           = 15


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# accurate task settings
item_settings = {
    'workdir'   : '.',
    'destdir'   : r'.\dummy',
    'client'    : r'C:\Program Files\TortoiseCVS\cvs.exe',
    'command'   : 'checkout',
    'cvsroot'   : 'benoitk@10.0.0.128:/home/netasq/sources',
    'cvsrsh'    : 'ssh',
    'module'    : 'IHM_Build',
  }

# dummy task settings
item_dummy     = {
  }


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


print ''

#~ aTaskItemDebug.classAttributes()
#~ print ''
#~ aTaskItemDebug.objectInit(enabled=False)
#~ aTaskItemDebug.objectDel()

#~ print ''
#~ print '# - - - - - - - - - - - - - - - - - - -'
#~ print ''


aTaskItemDebug.objectInit(enabled=True)
#~ aTaskItemDebug.objectCallFunc('debug')
print ''
aTaskItemDebug.objectBatchSetAttr(item_settings)
aTaskItemDebug.objectBatchSetAttr(item_dummy)


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# check that values stand where they are expected to be
for (key, val) in item_settings.iteritems() :
  buffer = aTaskItemDebug.objectGetAttr(key)
  assert val == buffer  , "attribute `%s` - got %s expected %s" % (key, repr(buffer), repr(val))

# check others dictionnary
buffer = aTaskItemDebug.objectGetAttr('others')
assert isinstance(buffer, dict), "task.others : dictionnary expected"
buffer = buffer.keys()
for key in item_dummy.iterkeys() :
  assert key in buffer, "`%s` missing from the 'others' dictionnary." % (key, )

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


#~ print ''
#~ aTaskItemDebug.objectCallFunc('debug')
print ''

aTaskItemDebug.objectCallFunc('completePaths', baseDir=None)
#~ aTaskItemDebug.objectCallFunc('debug')

print ''
print '# - - - - - - - - - - - - - - - - - - -'
print ''


#~ buffer = aTaskItemDebug.objectCallFunc('check')
#~ asqRepr.representation(buffer)

#~ print ''
#~ print '# - - - - - - - - - - - - - - - - - - -'
#~ print ''


#~ aTaskItemDebug.objectCallFunc('reset')
#~ print ''
#~ aTaskItemDebug.objectCallFunc('debug')
#~ print '# - - - - - - - - - - - - - - - - - - -'
#~ print ''


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


#~ aTaskHandlerDebug.classAttributes()
#~ print ''
#~ aTaskHandlerDebug.objectInit(aTask=None)
#~ aTaskHandlerDebug.objectDel()

#~ print ''
#~ print '# - - - - - - - - - - - - - - - - - - -'
#~ print ''

aTaskHandlerDebug.objectInit(aTask=aTaskItemDebug.object)

buffer = aTaskHandlerDebug.objectCallFunc('task.check')
buffer.report(DBG_LOGGER)


print ''
print '# - - - - - - - - - - - - - - - - - - -'
print ''


workdir = os.getcwd()


buffer = aTaskHandlerDebug.objectCallFunc('task.antDisplay')
DBG_LOGGER.debug(buffer)
#~ asqRepr.representation(buffer)


buffer = aTaskHandlerDebug.objectCallFunc('run')
asqRepr.representation(buffer)

#~ buffer = aTaskHandlerDebug.objectGetAttr('output')
#~ asqRepr.representation(buffer)

assert os.getcwd() == workdir, "failed to restore previous work directory"

# cleanup the mess
if aTaskItemDebug.objectGetAttr('destdir') is None :
  pass
elif os.path.exists(aTaskItemDebug.object.destdir) :
  asqPath.delete(aTaskItemDebug.object.destdir, True)


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -