#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
Imports all needed stuff from "tasks" package units into package's
namespace.

Require
  Python        2.2.2

Constants
  tuple         taskTypes
  string        cvsTaskType
  string        dccTaskType
  string        delTaskType
  string        rawTaskType
  string        resTaskType
  string        sf6TaskType
  string        svnTaskType
  string        vrsTaskType
  string        mailTaskType

Functions
  var           taskItemClass(string aType)
  var           taskListClass(string aType)
  var           taskHandlerClass(string aType)

Classes
  class         factory(object)
  class         globalTaskHandler(object aTask)
                  extends py_netasq.building.core::taskHandler

  class         cvsTaskItem(bool enabled)
                  extends py_netasq.building.core::taskItem
  class         dccTaskItem(bool enabled)
                  extends py_netasq.building.core::taskItem
  class         delTaskItem(bool enabled)
                  extends py_netasq.building.core::taskItem
  class         rawTaskItem(bool enabled)
                  extends py_netasq.building.core::taskItem
  class         resTaskItem(bool enabled)
                  extends py_netasq.building.core::taskItem
  class         sf6TaskItem(bool enabled)
                  extends py_netasq.building.core::taskItem
  class         svnTaskItem(bool enabled)
                  extends py_netasq.building.core::taskItem
  class         vrsTaskItem(bool enabled)
                  extends py_netasq.building.core::taskItem
  class         mailTaskItem(bool enabled)
                  extends py_netasq.building.core::taskItem

  class         cvsTaskList(bool enabled)
                  extends py_netasq.building.core::taskList
  class         dccTaskList(bool enabled)
                  extends py_netasq.building.core::taskList
  class         delTaskList(bool enabled)
                  extends py_netasq.building.core::taskList
  class         rawTaskList(bool enabled)
                  extends py_netasq.building.core::taskList
  class         resTaskList(bool enabled)
                  extends py_netasq.building.core::taskList
  class         sf6TaskList(bool enabled)
                  extends py_netasq.building.core::taskList
  class         svnTaskList(bool enabled)
                  extends py_netasq.building.core::taskList
  class         vrsTaskList(bool enabled)
                  extends py_netasq.building.core::taskList
  class         mailTaskList(bool enabled)
                  extends py_netasq.building.core::taskList

  class         cvsTaskHandler(object aTask)
                  extends py_netasq.building.core::taskHandler
  class         dccTaskHandler(object aTask)
                  extends py_netasq.building.core::taskHandler
  class         delTaskHandler(object aTask)
                  extends py_netasq.building.core::taskHandler
  class         rawTaskHandler(object aTask)
                  extends py_netasq.building.core::taskHandler
  class         resTaskHandler(object aTask)
                  extends py_netasq.building.core::taskHandler
  class         sf6TaskHandler(object aTask)
                  extends py_netasq.building.core::taskHandler
  class         svnTaskHandler(object aTask)
                  extends py_netasq.building.core::taskHandler
  class         vrsTaskHandler(object aTask)
                  extends py_netasq.building.core::taskHandler
  class         mailTaskHandler(object aTask)
                  extends py_netasq.building.core::taskHandler
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.15 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# __all__ should contain the entire public API. It is intended to avoid
# accidentally exporting items that are not part of the API (such as
# library modules which were imported and used within the module).

__all__ = [
    'cvsTask',
    'dccTask',
    'delTask',
    'rawTask',
    'resTask',
    'sf6Task',
    'svnTask',
    'vrsTask',
    'mailTask',
    
    'factory',
    'handlers',
  ]

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

from    cvsTask                 import  cvsTaskType, cvsTaskItem, cvsTaskList, cvsTaskHandler
from    dccTask                 import  dccTaskType, dccTaskItem, dccTaskList, dccTaskHandler
from    delTask                 import  delTaskType, delTaskItem, delTaskList, delTaskHandler
from    rawTask                 import  rawTaskType, rawTaskItem, rawTaskList, rawTaskHandler
from    resTask                 import  resTaskType, resTaskItem, resTaskList, resTaskHandler
from    sf6Task                 import  sf6TaskType, sf6TaskItem, sf6TaskList, sf6TaskHandler
from    svnTask                 import  svnTaskType, svnTaskItem, svnTaskList, svnTaskHandler
from    vrsTask                 import  vrsTaskType, vrsTaskItem, vrsTaskList, vrsTaskHandler

from    mailTask                import  mailTaskType, mailTaskItem, mailTaskList, mailTaskHandler

from    factory                 import taskTypes, factory
from    factory                 import taskItemClass, taskListClass, taskHandlerClass
from    handlers                import globalTaskHandler


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

if '__main__' == __name__ :
  print __file__
  print __doc__

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -