#!/usr/bin/env python

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
asqTypes (basic) test suite
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.3 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

import  unittest

from    py_netasq.commonlib             import asqLogging
from    py_netasq.building              import tasks    as asqTasks
from    py_netasq                       import building as asqBuild


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# globally disable TRACE logging message
asqBuild.logger.excludeLvl.append(asqLogging.TRACE)

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


class test_asqTasks(unittest.TestCase) :

    def testProtos1(self) :
        """\
          check if missing parameters or invalid types do raise exceptions.
        """
        self.assertRaises(TypeError, asqTasks.taskItemClass)
        self.assertRaises(TypeError, asqTasks.taskListClass)
        self.assertRaises(TypeError, asqTasks.factory.taskItemFromList)
        self.assertRaises(TypeError, asqTasks.factory.taskListFromList)
        self.assertRaises(TypeError, asqTasks.factory.buildTaskItem)
        self.assertRaises(TypeError, asqTasks.factory.buildTaskList)
        self.assertRaises(TypeError, asqTasks.factory.buildTaskHandler)


    def testTaskItemFromList1(self) :
        """\
          check taskItemFromLists() result.
        """
        buffer = asqTasks.factory.taskItemFromList([], asqTasks.cvsTaskType)
        self.failIf(buffer is None)
        self.assert_( not hasattr(buffer, 'count') )


    def testTaskListFromList1(self) :
        """\
          check taskListFromLists() result.
        """
        buffer = asqTasks.factory.taskListFromList([], asqTasks.cvsTaskType)
        self.failIf(buffer is None)
        self.assert_( hasattr(buffer, 'count') )


    def testTaskItemClass1(self) :
        """\
          check taskItemClass() result.
        """
        self.assertRaises(ValueError, asqTasks.taskItemClass, 'nawak')
        buffer = asqTasks.taskItemClass(asqTasks.cvsTaskType)
        self.failIf(buffer is None)


    def testTaskListClass1(self) :
        """\
          check taskListClass() result.
        """
        self.assertRaises(ValueError, asqTasks.taskListClass, 'nawak')
        buffer = asqTasks.taskListClass(asqTasks.cvsTaskType)
        self.failIf(buffer is None)


    def testTaskHandlerClass1(self) :
        """\
          check taskHandlerClass() result.
        """
        self.assertRaises(ValueError, asqTasks.taskHandlerClass, 'nawak')
        buffer = asqTasks.taskHandlerClass(asqTasks.cvsTaskType)
        self.failIf(buffer is None)


  # /class test_asqTasks  - - - - - - - - - - - - - - - - - - - - - - - - - - -


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

if '__main__' == __name__ :
    unittest.main()

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -