#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
Imports all needed stuff from "parsing" package units into package's
namespace.

Require
  Python        2.2

Classes
  class         fileParser(dict defaults)
                  extends py_netasq.commonlib.asqIniParser::asqIniParser
  class         fileChecker(dict defaults)
                  extends py_netasq.building.parsing.iniParser::fileParser
  class         fileHandler(dict defaults)
                  extends py_netasq.building.parsing.iniChecker::fileChecker
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.9 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# __all__ should contain the entire public API. It is intended to avoid
# accidentally exporting items that are not part of the API (such as
# library modules which were imported and used within the module).

__all__ = [
    'iniParser',
    'iniChecker',
    'iniHandler',
  ]

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

from    iniHandler              import VERBOSITY_RANGE
from    iniHandler              import VERBOSITY_SILENT, VERBOSITY_QUIET, VERBOSITY_NORMAL

from    iniParser               import fileParser
from    iniChecker              import fileChecker
from    iniHandler              import fileHandler


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

if '__main__' == __name__ :
  print __file__
  print __doc__


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -