#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.3 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

import  logging

from    py_netasq.commonlib     import asqDebug, asqLogging, asqRepr

from    py_netasq               import building as asqBuild
from    py_netasq.building      import core     as asqBuildCore
from    py_netasq.building      import tasks    as asqBuildTasks
from    py_netasq.building      import parsing  as asqBuildParsing


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

DBG_LOGGER = asqBuild.logger
DBG_LOGLVL = logging.INFO

# globally disable TRACE logging message
asqBuild.logger.excludeLvl.append(asqLogging.TRACE)

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

aParserDebug = asqDebug.objectDebug(asqBuildParsing.fileParser, 'aParserDebug')
aParserDebug.logger             = DBG_LOGGER
aParserDebug.logLevel           = DBG_LOGLVL

asqRepr.aRepr.logger            = DBG_LOGGER
asqRepr.aRepr.logLevel          = logging.DEBUG
asqRepr.aRepr.maxstring         = 40
asqRepr.aRepr.maxlist           = 15
asqRepr.aRepr.maxdict           = 15


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


print ''

aParserDebug.objectInit()

aParserDebug.objectCallFunc('readFile', filename='AdminSuite.ini')
print ''

aParserDebug.objectCallFunc('projectHelp', filename='AdminSuite.ini', display=DBG_LOGGER)
print ''

aParserDebug.objectCallFunc('debug')



# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -