#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.7 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

import  logging
import  os

from    py_netasq.commonlib     import asqDebug, asqLogging
from    py_netasq.commonlib     import asqPath, asqRepr

from    py_netasq               import building as asqBuild
from    py_netasq.building      import core     as asqBuildCore
from    py_netasq.building      import tasks    as asqBuildTasks
from    py_netasq.building      import parsing  as asqBuildParsing


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

DBG_LOGGER = asqBuild.logger
DBG_LOGLVL = logging.INFO

# globally disable TRACE logging message
asqBuild.logger.excludeLvl.append(asqLogging.TRACE)

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

aParserDebug = asqDebug.objectDebug(asqBuildParsing.fileHandler, 'aHandlerDebug')
aParserDebug.logger     = DBG_LOGGER
aParserDebug.logLevel   = DBG_LOGLVL

asqRepr.aRepr.logger    = DBG_LOGGER
asqRepr.aRepr.logLevel  = logging.DEBUG
asqRepr.aRepr.maxstring = 40
asqRepr.aRepr.maxlist   = 15
asqRepr.aRepr.maxdict   = 15


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


print ''

aParserDebug.objectInit()
#~ aParserDebug.objectCallFunc('readFile', filename='AdminSuite.ini')
#~ tmp_logger = aParserDebug.objectGetAttr('logger')


buffer = aParserDebug.objectCallFunc(
    'handleFile',
    filename='AdminSuite.ini',
    display=DBG_LOGGER,
    verbosity=asqBuildParsing.VERBOSITY_SILENT,
    sections=['CvsTasks']
  )
asqRepr.representation(buffer)
print ''

buffer = aParserDebug.objectCallFunc(
    'handleFile',
    filename='AdminSuite.ini',
    display=DBG_LOGGER,
    verbosity=asqBuildParsing.VERBOSITY_QUIET,
    sections=['CvsTasks', 'Mailing']
  )
asqRepr.representation(buffer)
print ''

buffer = aParserDebug.objectCallFunc(
    'handleFile',
    filename='AdminSuite.ini',
    display=DBG_LOGGER,
    verbosity=asqBuildParsing.VERBOSITY_NORMAL,
    sections=['CvsTasks']
  )
asqRepr.representation(buffer)
print ''


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -